/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/**
 * Entrypoint for browser builds
 * Insert instances of browser-specific interfaces and polyfills here
 * ie. Storage
 */
import { AdobeDCXBranch as IAdobeDCXBranch, AdobeDCXComposite as IAdobeDCXComposite, AdobeDCXElement as IAdobeDCXElement } from '@dcx/common-types';
import '@dcx/core';
import { AdobeHTTPService } from '@dcx/http';
import { AdobeDCXLogger } from '@dcx/logger';
import '@dcx/polyfill';
import * as _AdobeDCXUtil from '@dcx/util';
import { AdobeCommunityPublicationRecord } from './src/AdobeCommunityPublicationRecord';
import { AdobeCommunitySession } from './src/AdobeCommunitySession';
import { AdobeDCXComposite, AdobeDCXCompositeOptions } from './src/AdobeDCXComposite';
import { AdobeRemixData } from './src/AdobeRemixData';
export { AdobeDCXError, DCXError, isAdobeDCXError } from '@dcx/error';
export { AdobeHTTPService, createHTTPService } from '@dcx/http';
export { /* istanbul ignore next */ AdobeDCXLogger, /* istanbul ignore next */ getGlobalLogger } from '@dcx/logger';
export * from '@dcx/promise';
export * from '@dcx/repo-api-session';
export { AdobeCommunityPlatform, AdobeCommunityPlatform as communityPlatform, } from './src/AdobeCommunityPlatform';
export { /* istanbul ignore next */ AdobeCommunityPublicationRecord } from './src/AdobeCommunityPublicationRecord';
export { AdobeCommunitySession, AdobeCommunitySession as CommunitySession, } from './src/AdobeCommunitySession';
export { /* istanbul ignore next */ AdobeDCXBranch } from './src/AdobeDCXBranch';
export { /* istanbul ignore next */ AdobeDCXComponent } from './src/AdobeDCXComponent';
export { AdobeDCXComposite, AdobeDCXCompositeOptions, convertToDCXComposite, createComposite, newDCXComposite, } from './src/AdobeDCXComposite';
export { /* istanbul ignore next */ AdobeDCXElement } from './src/AdobeDCXElement';
export { /* istanbul ignore next */ AdobeDCXNode } from './src/AdobeDCXNode';
export { /* istanbul ignore next */ AdobeDCXPushJournal } from './src/AdobeDCXPushJournal';
export { AdobeRemixData, AdobeRemixData as RemixData, } from './src/AdobeRemixData';
export { XMPModes, copyResources, getCompositeManifestAndComponentsByPath, getURLForComponent, pullCompositeManifestOnly, pullCompositeVersionManifestOnly, pushComposite, uploadComponent, uploadNewComponent, } from './src/CompositeXfer';
export declare const AdobeNetworkHTTPService: new (authHandler?: import("@dcx/common-types").AdobeAuthProvider | import("@dcx/common-types").AuthenticationCallback | undefined, options?: import("@dcx/common-types").AdobeHTTPServiceOptions | undefined) => AdobeHTTPService;
export declare const HTTPService: new (authHandler?: import("@dcx/common-types").AdobeAuthProvider | import("@dcx/common-types").AuthenticationCallback | undefined, options?: import("@dcx/common-types").AdobeHTTPServiceOptions | undefined) => AdobeHTTPService;
/**
 * Export classes by name for backwards compatibility
 */
/** @public */
export declare const logger: AdobeDCXLogger;
/** @public */
export declare const AdobeDCXUtil: typeof _AdobeDCXUtil;
/**
 * The different types of collaboration for a composite. You can set the collaboration type
 * directly on a {@link AdobeDCX#Composite|AdobeDCXComposite} object.
 * @enum {String}
 * @public
 */
export declare const COLLABORATION: Record<"PRIVATE" | "SHARED_WITH_USER" | "SHARED_BY_USER", string>;
/**
 * Creates and returns a new composite object that is a copy of compositeBranchOrElement.
 * @public
 *
 * @param   {Object}    compositeOrBranchOrElement As the name implies this param is expected to be
 *                                                  either a composite (with a valid current branch),
 *                                                  a branch or an element. Furthermore it may (at
 *                                                  this point in time) not contain an new or modified
 *                                                  components.
 * @param   {String}    [name]                     An optional new name for the new composite. If undefined
 *                                                  the composite will have the same name as the original.
 * @param   {String}    [type]                     An optional new type for the new composite. If undefined
 *                                                   the composite will have the same type as the original.
 * @param   {String}    [id]                       An optional new id for the new composite. If undefined
 *                                                  the composite will get a random new id.
 * @param {AdobeDCXCompositeOptions} [options]                   Creation options
 */
export declare const newCompositeAsCopyOf: (compositeOrBranchOrElement: IAdobeDCXComposite | IAdobeDCXBranch | IAdobeDCXElement, name?: string, type?: string, id?: string, options?: AdobeDCXCompositeOptions) => AdobeDCXComposite;
/**
 * Constructs and returns a community session instance.
 * @public
 * @example
 * ```js
 * const service = // create instance of AdobeHTTPService
 * ...
 * const session = createCommunitySession(service, 'https://my.proxy.adobe.com/cp');
 * ```
 * @param   {AdobeHTTPService}    httpService The HTTP service.
 * @param   {String}              endpoint    The url for the storage server.
 */
export declare const createCommunitySession: (httpService: AdobeHTTPService, endpoint: string) => AdobeCommunitySession;
/**
 * Constructs and returns a remixData instance.
 * @public
 */
export declare const createRemixData: () => AdobeRemixData;
/**
 * The {@link ./src/AdobeRemixData} class.  Gives access to the DCX AdobeCommunityPublicationRecord which represents publishing data for the Community Platform..
 * @readonly
 * @public
 * @type {AdobeRemixData}
 */
export declare const CommunityPublicationRecord: typeof AdobeCommunityPublicationRecord;
/**
 * Constructs and returns a {@link ./src/AdobeCommunityPublicationRecord} instance.
 * @public
 */
export declare const createCommunityPublicationRecord: () => AdobeCommunityPublicationRecord;
//# sourceMappingURL=index.d.ts.map