/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { RepoResponseResult } from '@dcx/assets';
import { AdobeAsset, AdobeDCXComposite, AdobeDCXError } from '@dcx/common-types';
import { AdobeRepoAPISession } from '@dcx/repo-api-session';
import AdobeCommunityPublicationRecord from './AdobeCommunityPublicationRecord';
import AdobeCommunitySession from './AdobeCommunitySession';
import AdobeRemixData from './AdobeRemixData';
/**
 * @class AdobeCommunityPlatform
 * @classdesc AdobeCommunityPlatform is a static class that implements methods for publishing/remixing DCX composites to/from CP.
 * <p>Clients do not need to require() the class since a reference to it is available via their instance
 * of {@link AdobeDCX}.
 * @hideconstructor
 */
/**
 * Callback for monitoring progress of the various transfer functions.
 * @callback ProgressCallback
 *    @param {Integer} bytesCompleted
 *    @param {Integer} totalBytes
 */
/**
 * @class
 * @hideconstructor
 * @classdesc An XferContext object is returned when a transfer is initiated.
 * Clients can use it to abort the transfer or register a progress handler with the context.
 * @property {Integer}          [bytesTransfered]   The current number of bytes transfered.
 * @property {Integer}          [bytesTotal]        The total number of bytes to transfer.
 * @property {ProgressCallback} [onProgress]        Set this to a progressCallback function if you
 *                                                  want to receives progress callbacks.
 * @property {Array}            [failedComponents]  Upon failure this it is an array of
 *                                                  { component: component, error: error } for
 *                                                  each component that failed to down or upload.
 */
declare class XferContext {
    private _session;
    private _callback;
    private _cleanup;
    private _componentsPending;
    private _bytesTransfered;
    private _bytesTotal;
    private _onProgress;
    private _reportProgress;
    private _aborted;
    constructor(session: AdobeCommunitySession, callback: any, cleanup?: any);
    /**
     * @internal
     */
    get xferComplete(): (completionError: any, result?: any) => any;
    /**
     * Is true if the xfer has been aborted.
     * @memberof XferContext#
     * @type {Boolean}
     */
    get aborted(): boolean;
    /**
     * The number of bytes already transfered
     * @memberof XferContext#
     * @type {Integer}
     */
    get bytesTransfered(): number;
    /**
     * The total number of bytes to transfer
     * @memberof XferContext#
     * @type {Integer}
     */
    get bytesTotal(): number;
    /**
     * The progress callback that should get called on progress.
     * @memberof XferContext#
     * @type {ProgressCallback}
     */
    set onProgress(progressCallback: any);
    get onProgress(): any;
    /**
     * Call the client callback. Repeated calls will get ignored.
     * @private
     */
    private _callCallback;
    /**
     * Called when the xfer has either succeeded or failed.
     * @private
     */
    private _xferComplete;
    /**
     * Call this to abort the transfer.
     * @param {Error} [error] If not undefined then the callback for the xfer gets
     *                        invoked and passed this as the first (error) argument.
     */
    abort(abortError: AdobeDCXError | Error): any;
}
export declare class AdobeCommunityPlatform {
    private static pubsAsset;
    /**
     * @private
     */
    private constructor();
    /**
     Create composite at pubs location.
        @param session      The repo session to use
        @param relPath      Path at which new composite will be created in the cloud, relative to /pubs
        @param contentType  Content type of composite
     */
    static createCompositeAtPubs(session: AdobeRepoAPISession, relPath: string, contentType: string): Promise<RepoResponseResult<AdobeAsset>>;
    /**
     Publish composite to Community Platform.
        @param composite Composite to be published
        @param compositeHref Path of the composite directory in ccStorage
        @param pubRecord
        @param [remixData]
        @param [creatorTool]
        @param callback signature: callback(error, pubRecord)
     */
    static publishCompositeAlreadyPushedToPubs(composite: AdobeDCXComposite, pubRecord: AdobeCommunityPublicationRecord, remixData: AdobeRemixData | undefined, creatorTool: string | undefined, communitySession: AdobeCommunitySession, callback: any): XferContext;
    static getCpMetadata(communitySession: AdobeCommunitySession, pubRecord: AdobeCommunityPublicationRecord, callback: any): void;
}
export default AdobeCommunityPlatform;
//# sourceMappingURL=AdobeCommunityPlatform.d.ts.map