/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
export interface AdobeCommunityPublicationRecordMetadata {
    title?: string;
    description?: string;
    alias?: string;
    undiscoverable?: boolean;
    private?: boolean;
    tags?: string[];
    creator_ids?: string[];
    category_id?: string;
    sub_category_ids?: string[];
    custom?: unknown;
    main_resource?: {
        resource_path?: string;
        resource_version?: string;
    };
    artwork?: {
        resource_path?: string;
        resource_version?: string;
    };
}
/**
 * @class
 * @classdesc AdobeCommunityPublicationRecord represents publishing data for the Community Platform.
 * <p>The constructor for AdobeCommunityPublicationRecord is private. Refer to {@link AdobeDCX} to learn how
 * to create instances of AdobeCommunityPublicationRecord.
 * @hideconstructor
 */
export declare class AdobeCommunityPublicationRecord {
    private _communityId;
    private _artworkComponentId;
    private _assetId;
    private _resourcePath;
    private _mainResource;
    private _mainResourceVersion;
    private _artworkResource;
    private _artworkResourceVersion;
    private _title;
    private _alias;
    private _tags;
    private _description;
    private _categoryId;
    private _subCategoryIds;
    private _creatorIds;
    private _undiscoverable;
    private _isPrivate;
    private _custom;
    get communityId(): string | null;
    set communityId(communityId: string | null);
    get artworkComponentId(): string | null;
    set artworkComponentId(artworkComponentId: string | null);
    get assetId(): string | null;
    set assetId(assetId: string | null);
    get resourcePath(): string | null;
    set resourcePath(resourcePath: string | null);
    get mainResource(): any;
    set mainResource(mainResource: any);
    get mainResourceVersion(): string | null;
    set mainResourceVersion(mainResourceVersion: string | null);
    get artworkResource(): string | null;
    set artworkResource(artworkResource: string | null);
    get artworkResourceVersion(): string | null;
    set artworkResourceVersion(artworkResourceVersion: string | null);
    get title(): string | null;
    set title(title: string | null);
    get alias(): string | null;
    set alias(alias: string | null);
    get tags(): string[];
    set tags(tags: string[]);
    get description(): string | null;
    set description(description: string | null);
    get categoryId(): string | null;
    set categoryId(categoryId: string | null);
    get subCategoryIds(): string[];
    set subCategoryIds(subCategoryIds: string[]);
    get creatorIds(): string[];
    set creatorIds(creatorIds: string[]);
    get undiscoverable(): boolean;
    set undiscoverable(undiscoverable: boolean);
    get isPrivate(): boolean;
    set isPrivate(isPrivate: boolean);
    get custom(): unknown;
    set custom(custom: unknown);
}
export default AdobeCommunityPublicationRecord;
//# sourceMappingURL=AdobeCommunityPublicationRecord.d.ts.map