import { AdobeDCXBranch, AdobeDCXComponent, AdobeDCXComposite, AdobeHTTPService, AdobeResponse, AdobeResponseType, RequestDescriptor } from '@dcx/common-types';
import { AdobeDCXError } from '@dcx/error';
import AdobeCommunityPublicationRecord from './AdobeCommunityPublicationRecord';
import { SessionBase } from './AdobeSessionBase';
/**
 * @class
 * @classdesc  Session interface for the CP service.
 * <p>The constructor for AdobeCommunitySession is private. See {@link AdobeDCX}
 * to learn how to create an AdobeCommunitySession and what to use it for.</p>
 * @augments AdobeSessionBase
 * @hideconstructor
 * @param httpService the HTTP service
 * @param server      the url for the storage server
 */
export declare class AdobeCommunitySession extends SessionBase {
    readonly name = "AdobeCommunitySession";
    constructor(httpService: AdobeHTTPService, server: string);
    /** @private */
    publishCompositeAtResource(type: string, pubRecord: AdobeCommunityPublicationRecord, callback: any): import("@dcx/common-types").IAdobePromise<AdobeResponse<"text">, import("@dcx/common-types").AdobeDCXError<unknown>, RequestDescriptor>;
    /** @internal */
    updateCpMetadataAtResource(type: string, pubRecord: AdobeCommunityPublicationRecord, callback: (error?: AdobeDCXError, result?: any) => void): import("@dcx/common-types").IAdobePromise<AdobeResponse<"text">, import("@dcx/common-types").AdobeDCXError<unknown>, RequestDescriptor>;
    /** @internal */
    getCpMetadata(pubRecord: AdobeCommunityPublicationRecord, callback: any): void;
    /** @private */
    updatePublicationRecordData(pubRecord: AdobeCommunityPublicationRecord, pushedBranch: AdobeDCXBranch): void;
    /**
     * Gets the href for the manifest of the given composite.
     * @private
     * @param composite the composite.
     */
    getCompositeManifestHref(composite: AdobeDCXComposite, versionId: string, getHrefCallback: any): string;
    /**
     * Gets a component from the server.
     * NOTE that this does not specify an If-Match header. We want to get the component
     * whether the etags match or not, for instance when we don't have the local file present.
     * @private
     * @param   {AdobeDCXComponent} component    The component to download.
     * @param   {String}            responseType The expected data type of the response.
     * @param   {Function}          callback     Callback
     * @returns {Object}            the requestDescriptor for the request.
     */
    getComponent(component: AdobeDCXComponent, responseType: AdobeResponseType, callback: any): RequestDescriptor;
    /**
     * Gets a rendition of a component from the server.
     * NOTE that this does not specify an If-Match header. We want to get the component
     * whether the etags match or not, for instance when we don't have the local file present.
     * @private
     * @param   {AdobeDCXComponent} component    The component to download.
     * @param   {String}            type         The media type of the rendition 'image/jpeg' or 'image/png'.
     * @param   {String}            dimension    'width' or 'height'
     * @param   {Integer}           size         The requested number of pixels in the dimension.
     * @param   {String}            responseType The expected data type of the response.
     * @param   {Function}          callback     Callback
     * @returns {Object}            the requestDescriptor for the request.
     */
    getRenditionOfComponent(component: AdobeDCXComponent, type: string, dimension: string, size: number, responseType: AdobeResponseType, callback: any): RequestDescriptor;
    /** @private */
    getCompositeManifest(composite: AdobeDCXComposite, versionId: string, etag: string, callback: any): any;
    /**
     * Issue a simple HEAD request.
     * @private
     * @return         the requestDesc
     * @param href     the URL
     * @param callback signature: callback(error, response)
     */
    headRequest(href: string, callback: (err: Error, response?: AdobeResponse) => void): RequestDescriptor;
    /** @internal */
    getComponentHref(component: AdobeDCXComponent, version: string, getHrefCallback: (err?: AdobeDCXError, href?: string) => void | RequestDescriptor): void;
    /** @internal */
    getComponentRenditionHref(component: AdobeDCXComponent, version: string, type: string, dimension: string, size: number, getHrefCallback: (err?: AdobeDCXError, href?: string) => void): void;
    /**
     * Checks string prefix to see if it conforms to a proper asset id (href) for the CCStorage service
     * @private
     * @param   {String} assetId The asset id in question
     * @returns {Boolean}
     */
    private isProperAssetId;
    /** @private */
    private _constructComponentHref;
    /** @private */
    private _constructComponentRenditionHref;
    /** @private */
    private _hrefUsesContentApis;
    /** @private */
    private assetIdFromSSResourceHref;
    /** @private */
    private metadataFromPubRecord;
}
export default AdobeCommunitySession;
//# sourceMappingURL=AdobeCommunitySession.d.ts.map