/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeDCXBranch, AdobeDCXComponentData, AdobeDCXElement, AdobeDCXState, AdobeUploadRecord, HalLink, AdobeDCXComponent as IAdobeDCXComponent } from '@dcx/common-types';
import DCXBranch from './AdobeDCXBranch';
import DCXElement from './AdobeDCXElement';
/**
 * @class
 * @classdesc AdobeDCXComponent represents a component of a DCX manifest.
 * <p>The constructor for AdobeDCXComponent is private. Refer to {@link AdobeDCXBranch} to
 * learn how to access existing components or create new ones.
 * @hideconstructor
 * @param {Object}  data
 * @param {Boolean} readOnly
 */
export declare class AdobeDCXComponent implements IAdobeDCXComponent {
    /** @internal */
    private _readOnly;
    /** @internal */
    private _compositeId?;
    /** @internal */
    _data: AdobeDCXComponentData;
    /** @internal */
    _owner?: DCXBranch | DCXElement;
    /** @internal */
    _parentPath?: string;
    /** @internal */
    _assetId?: string;
    /** @internal */
    _repoId?: string;
    records: Record<string, AdobeUploadRecord>;
    static readonly STATES: Record<AdobeDCXState, AdobeDCXState>;
    constructor(data?: AdobeDCXComponentData, readOnly?: boolean);
    get compositeId(): string | undefined;
    get owner(): AdobeDCXBranch | AdobeDCXElement | undefined;
    get data(): AdobeDCXComponentData;
    /**
     * The id of the component. Must be a unique among the components of the composite.
     *
     * <p>Cannot be changed for a component that is part of a branch.</p>
     * @memberof AdobeDCXComponent#
     * @type {String}
     */
    get id(): string;
    set id(id: string);
    /**
     * The name of the component.
     *
     * @memberof AdobeDCXComponent#
     * @type {String}
     */
    get name(): string | undefined;
    set name(name: string | undefined);
    /**
     * The type of the component.
     *
     * @memberof AdobeDCXComponent#
     * @type {String}
     */
    get type(): string;
    set type(type: string);
    /**
     * The path of the component.
     *
     * @memberof AdobeDCXComponent#
     * @type {String}
     */
    get path(): string;
    set path(path: string);
    /**
     * The absolute path of the parent of the component.
     *
     * @memberof AdobeDCXComponent#
     * @readonly
     * @type {String}
     */
    get parentPath(): string | undefined;
    set parentPath(_: string | undefined);
    /**
     * The absolute path of the component.
     *
     * @memberof AdobeDCXComponent#
     * @readonly
     * @type {String}
     */
    get absolutePath(): string | undefined;
    set absolutePath(_: string | undefined);
    /**
     * The relationship of the component to its parent node and its sibling components.
     *
     * @memberof AdobeDCXComponent#
     * @type {String}
     */
    get relationship(): string | undefined;
    set relationship(relationship: string | undefined);
    /**
     * The edit state of the component.
     *
     * @memberof AdobeDCXComponent#
     * @readonly
     * @private
     * @type {String}
     */
    get state(): AdobeDCXState;
    set state(state: AdobeDCXState);
    /**
     * The etag of the component.
     *
     * @memberof AdobeDCXComponent#
     * @readonly
     * @private
     * @type {String}
     */
    get etag(): string | undefined;
    set etag(etag: string | undefined);
    /**
     * The md5 of the component.
     *
     * @memberof AdobeDCXComponent#
     * @readonly
     * @private
     * @type {String}
     */
    get md5(): string | undefined;
    set md5(md5: string | undefined);
    /**
     * The version of the component.
     *
     * @memberof AdobeDCXComponent#
     * @readonly
     * @private
     * @type {String}
     */
    get version(): string | undefined;
    set version(version: string | undefined);
    /**
     * The content length of the component.
     *
     * @memberof AdobeDCXComponent#
     * @readonly
     * @type {Integer}
     */
    get length(): number | undefined;
    set length(length: number | undefined);
    /**
     * The width property of the component.
     *
     * @memberof AdobeDCXComponent#
     * @type {Number}
     */
    get width(): number | undefined;
    set width(width: number | undefined);
    /**
     * The height property of the component.
     *
     * @memberof AdobeDCXComponent#
     * @type {Number}
     */
    get height(): number | undefined;
    set height(height: number | undefined);
    /**
     * The asset id of the component in cloud storage
     *
     * @memberof AdobeDCXComponent#
     * @type {String}
     */
    get assetId(): string | undefined;
    set assetId(assetId: string | undefined);
    /**
     * The repo id of the component in cloud storage
     *
     * @memberof AdobeDCXComponent#
     * @type {String}
     */
    get repositoryId(): string | undefined;
    set repositoryId(repoId: string | undefined);
    /**
     * Get a serialized component descriptor.
     *
     * @returns {string}
     *
     * ```ts
     * const componentDescriptor = component.getComponentDescriptor();
     * ```
     */
    getComponentDescriptor(): string;
    /**
     * Returns an array of custom keys that are present at this component. Custom keys are manifest
     * properties that are not considered standard DCX properties.
     * @returns {Array}
     */
    getCustomKeys(): string[];
    /**
     * Returns the object or value for the given custom key.
     * @param   {String} key The custom key to look up.
     * @returns {*}
     */
    getValue<T = any>(key: string): T;
    /**
     * Sets the object or value for the given custom key.
     * @param {String} key   The custom key to set the value for.
     * @param {*}      value The value to set.
     */
    setValue<T = any>(key: string, value: T): void;
    /**
     * Removes the object or value for the given custom key.
     * @param {String} key The custom key to remove.
     */
    removeValue(key: string): void;
    /**
     * Returns the link with the given relationship as a JS object or undefined if the component
     * doesn't have such a link.
     * @param   {String} relationship The relationship of the link to the component.
     * @returns {Object} The link object with the given relationship as a JS object or undefined if
     *                   the component doesn't have such a link.
     */
    getLink(relationship: string): HalLink | undefined;
    /**
     * Sets the link with the given relationship to the given object.
     * @param {Object} link         A JS object representing the link.
     * @param {String} relationship The relationship of the link to the component.
     */
    setLink(link: HalLink, relationship: string): void;
    /**
     * Removes the link with the given relationship.
     * @param {String} relationship The relationship of the link to the component.
     *
     */
    removeLink(relationship: string): void;
    /**
     * Returns false if any of the properties of the given component is different from the properties
     * of this component. Recurses both data structures.
     *
     * @example
     * if (!component.isEqualTo(otherComponent, { unimportantProperty: true })) {
     *      // The components have different properties
     * }
     * @param   {AdobeDCXComponent} component            The component to compare with.
     * @param   {Object}            [propertiesToIgnore] An object having the properties that should
     *                                                 not be compared.
     * @returns {Boolean}
     */
    isEqualTo(component: AdobeDCXComponent, propertiesToIgnore?: Record<string, boolean>): boolean;
    /**
     * Verifies and sets the new data. Throws if invalid data.
     * @private
     * @param   {Object}   data
     * @returns {AdobeDCXComponent}
     */
    private _setData;
    /**
     * Sets the dirty flag on the node's branch (if set)
     * @internal
     */
    _setDirty(): void;
    /**
     * Returns an error if the passed in data is not a valid component. Returns null if everything is OK.
     * @private
     * @param   {Object} data
     * @returns {Error}
     */
    private _verify;
}
export default AdobeDCXComponent;
//# sourceMappingURL=AdobeDCXComponent.d.ts.map