/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeAsset, Composite } from '@dcx/assets';
import { AdobeDCXBranch, AdobeDCXElement, AdobeDCXError, BranchCallback, GetSliceCallback, AdobeDCXComposite as IAdobeDCXComposite, Link, LinkSet, ResourceDesignator, SliceableData } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { AdobeRepoAPISession } from '@dcx/repo-api-session';
import DCXBranch from './AdobeDCXBranch';
import AdobeDCXPushJournal from './AdobeDCXPushJournal';
export declare const COLLABORATION: Record<'PRIVATE' | 'SHARED_WITH_USER' | 'SHARED_BY_USER', string>;
export interface AdobeDCXCompositeOptions {
    xhrBaseBranchSupport?: boolean;
    maxClientDataLength?: number;
}
/**
 * @class
 * @classdesc AdobeDCXComposite represents a DCX composite.
 * <p>The constructor for AdobeDCXComposite is private. Refer to {@link AdobeDCX} to learn how
 * to create instances of AdobeDCXComposite.
 * @hideconstructor
 * @param {String} name
 * @param {String} type
 * @param {String} id
 * @param {String} assetId
 * @param {Object} options
 */
export declare class AdobeDCXComposite implements IAdobeDCXComposite {
    /**
     * Constants for the collaborationType property.
     * @private
     */
    static readonly COLLABORATION: Record<"PRIVATE" | "SHARED_WITH_USER" | "SHARED_BY_USER", string>;
    /** @internal */
    private _clientDataString?;
    /** @internal */
    private _baseBranchData?;
    /** @internal */
    private _name;
    /** @internal */
    private _href?;
    /** @internal */
    private _assetId?;
    /** @internal */
    private _type;
    /** @internal */
    private _id;
    /** @internal */
    _current: DCXBranch;
    /** @internal */
    private _path;
    /** @internal */
    private _repoId;
    /** @internal */
    private _collaborationType;
    /** @internal */
    _options: AdobeDCXCompositeOptions;
    /** @internal */
    _pushJournal?: AdobeDCXPushJournal;
    /** @internal */
    _links?: LinkSet;
    /** @internal */
    _pushedBranchData?: string;
    /** @internal */
    _pulledBranchData?: string;
    constructor(name?: string, type?: string, id?: string, assetId?: string, repoId?: string | AdobeDCXCompositeOptions, options?: AdobeDCXCompositeOptions);
    get href(): string;
    set href(href: string);
    get links(): LinkSet | undefined;
    set links(links: LinkSet | undefined);
    get repositoryId(): string | undefined;
    set repositoryId(repoId: string | undefined);
    /**
     * The id of the composite.
     *
     * <p>While not strictly read-only most clients do not ever have to modify this property.</p>
     * @memberof AdobeDCXComposite#
     * @type {String}
     */
    get id(): string;
    set id(id: string);
    /**
     * The name of the composite.
     *
     * @memberof AdobeDCXComposite#
     * @type {String}
     */
    get name(): string;
    set name(name: string);
    /**
     * The type of the composite.
     *
     * @memberof AdobeDCXComposite#
     * @type {String}
     */
    get type(): string;
    set type(type: string);
    /**
     * The asset id of the composite that can be used to pull and push the composite.
     * <strong>Do not modify this for a bound composite.</strong>
     * @memberof AdobeDCXComposite#
     * @type {String}
     */
    get assetId(): string | undefined;
    set assetId(assetId: string | undefined);
    /**
     * Whether (and how) the composite is shared. See
     * {@link AdobeDCX.COLLABORATION}.
     * It is the client's responsibility to correctly set this property so that DCX can push
     * the composite correctly.
     * <p><strong>Composites with a collaboration type of AdobeDCX.COLLABORATION.SHARED_WITH_USER
     * must not be deleted. Use AdobeStorageSession.leaveSharedComposite() to remove a shared
     * composite from the user's sync group.</p>
     * // @TODO: Determine if this is still used/necessary in RAPI.
     * @memberof AdobeDCXComposite#
     * @type {String}
     * @default [COLLABORATION.PRIVATE]
     */
    get collaborationType(): string | undefined;
    set collaborationType(value: string | undefined);
    /**
     * User-defined data to associate with the composite - this can be an arbitrary string, up to a limit of 1KB.
     * This data is not synchronized to the server, but it is persisted locally to disk.
     *
     * @memberof AdobeDCXComposite#
     * @type {String}
     * @default [undefined]
     */
    get clientDataString(): string | undefined;
    set clientDataString(value: string | undefined);
    /**
     * Whether the composite is bound to a composite on a server. If <em>false</em> for newly
     * created empty composites that have never been pulled from or pushed to the server.
     * @readonly
     * @memberof AdobeDCXComposite#
     * @type {Boolean}
     */
    get isBound(): boolean;
    set isBound(_: boolean);
    /**
     * The editable current branch the composite. Is undefined in case of a composite that hasn't
     * been pulled from the server yet.
     * @readonly
     * @memberof AdobeDCXComposite#
     * @type {AdobeDCXBranch}
     */
    get current(): AdobeDCXBranch;
    /**
     * @private
     */
    set current(_: AdobeDCXBranch);
    /**
     * <p>Creates and returns a new composite object that is a copy of compositeBranchOrElement.</p>
     *
     * <p> The resulting composite will be in memory only and you can push it to the server, which
     * will result in the component files being copied on the server. </p>
     *
     * @param   {Object}            compositeOrBranchOrElement As the name implies this param is expected to be
     *                                                         either a composite (with a valid current branch),
     *                                                         a branch or an element. Furthermore it may (at
     *                                                         this point in time) not contain an new or modified
     *                                                         components.
     * @param   {String}            [name]                     An optional new name for the new composite. If undefined
     *                                                         the composite will have the same name as the original.
     * @param   {String}            [type]                     An optional new type for the new composite. If undefined
     *                                                         the composite will have the same type as the original.
     * @param   {String}            [id]                       An optional new id for the new composite. If undefined
     *                                                         the composite will get a random new id.
     * @param   {Object}            [options]                  See constructor.
     * @returns {AdobeDCXComposite} The new composite
     */
    static newCompositeAsCopyOf(compositeOrBranchOrElement: AdobeDCXBranch | IAdobeDCXComposite | AdobeDCXElement, name?: string, type?: string, id?: string, options?: AdobeDCXCompositeOptions): AdobeDCXComposite;
    /**
     * Loads the base manifest and instantiates a read-only branch if the manifest exists.
     *
     * <p>This method can only be called if the AdobeDCXComposite instance has been initialized with the
     * <em>xhrBaseBranchSupport</em> option.</p>
     *
     * @param {BranchCallback} callback Gets called on success or failure.
     */
    loadBaseBranch(): AdobePromise<AdobeDCXBranch, AdobeDCXError>;
    loadBaseBranch(callback: BranchCallback): void;
    /**
     * Callback function used for operations that return a branch.
     * @callback BranchCallback
     *    @param {Error}           error
     *    @param {AdobeDCXBranch}  branch
     */
    /**
     * Callback function used for operations that don't return anything other than a potential error.
     * @callback ErrorCallback
     *    @param {Error}           error
     */
    /**
     * Callback function used for operations that don't return anything other than an array if error
     * objects.
     * @callback ErrorsCallback
     *    @param {Array}           Array of error objects or undefined.
     */
    /**
     * Accepts the given merged branch as the new current branch, discards any temporary pull data
     * and also updates the base manifest. Is a no-op if no branch is provided and if there
     * is no pulled manifest in local storage (as may be the case if a pull didn't find any
     * modification on the server).
     *
     * @example
     * // NJS
     * pullComposite(composite, session, function (error, pulledBranch) {
     *      if (!error) {
     *          // The pull has succeeded. Now you need to incorporate the changes from the server
     *          // into your current branch.
     *          // Start the merge by making a mutable copy of pulledBranch
     *          var mergedBranch = pulledBranch.copy();
     *          // Now merge any changes you have made to current since the last successful push or
     *          // pull. You might want to also load the base branch to help you figure out what has
     *          // changed in either branch.
     *          ...
     *          // When done merging you need to make this call:
     *          composite.resolvePullWithBranch(mergedBranch, function (error, newCurrent) {
     *              if (!error) {
     *                  // Now you are done!
     *              }
     *          });
     *      }
     * });
     *
     * @example
     * // XHR
     * pullCompositeManifestOnly(composite, session, function (error, pulledBranch) {
     *      if (!error) {
     *          // The pull has succeeded. Now you need to incorporate the changes from the server
     *          // into your current branch. If you follow the recommendations for working in an
     *          // online environment you will not have modified current so you can just call:
     *          composite.resolvePullWithBranch(pulledBranch);
     *      }
     * });
     *
     *
     * <p><strong>The branch passed in must be derived from the pulled branch.</strong></p>
     *
     * @param {AdobeDCXBranch} branch     A branch which should become the new current branch. It
     *                                    should be the result of merging the previously pulled
     *                                    branch with any changes in current.
     * @param {BranchCallback} [callback] Optional if running in an <strong>XHR</strong>
     *                                    environment. Gets called on completion.
     * @return {AdobeDCXBranch}           Only returns the new current branch if called without
     *                                     a callback.
     */
    resolvePullWithBranch(branch: AdobeDCXBranch): void;
    resolvePullWithBranch(branch: AdobeDCXBranch, callback: BranchCallback): void;
    /**
     * Updates the current branch (both in memory and -- if applicable -- in local storage) with the
     * results of the most recent push, discards any temporary push data and updates base. Is a
     * no-op if there are no push results (because e.g. there were no changes to push).
     *
     * @example
     * // NJS
     * pushComposite(composite, false, session, function (error) {
     *      if (!error) {
     *          // The push has succeeded. You now need to accept it to update your current branch
     *          composite.acceptPush(function (error) {
     *              if (!error) {
     *                  // Now you are done!
     *              }
     *          });
     *      }
     * });
     *
     * @example
     * // XHR
     * pushComposite(composite, false, session, function (error) {
     *      if (!error) {
     *          // The push has succeeded. If you want to continue to work with the composite you
     *          // must accept the push -- otherwise you are done now
     *          composite.acceptPush();
     *      }
     * });
     *
     * @param   {ErrorCallback} [callback]  Optional when calling in an <strong>XHR</strong>
     *                                      environment. Gets called on completion.
     * @returns {AdobeDCXBranch}            Only returns the new current branch if called without
     *                                      a callback.
     */
    acceptPush(callback?: (err?: Error) => unknown): void | AdobeDCXBranch;
    /**
     * Removes all service-related data from the current banch and resets all other branches so that
     * the composite can be pushed again to the same or a different service.
     * @param {ErrorCallback} [callback] Optional if called from an <strong>XHR</strong>
     *                                   environment. Gets called on success or failure.
     */
    resetBinding(callback?: (err?: Error) => unknown): void;
    /**
     * Assigns a new id to the current branch and resets all other branches. Also removes all
     * service-related data from the current branch so that it can be pushed again to the same or
     * a different service.
     * @param {ErrorCallback} [callback] Optional if called from an <strong>XHR</strong>
     *                                   environment. Gets called on success or failure.
     */
    resetIdentity(callback?: (err?: Error) => unknown): void;
    /** Sets the path property and creates or updates local storage. */
    /**
     * @private
     * @param {String} path
     */
    private _setPath;
    /**
     * @internal
     */
    get _isRepoComposite(): boolean;
}
export default AdobeDCXComposite;
/**
 * Convenience APIs
 */
/**
 * Factory method for creating a R-API based DCXComposite.
 * To create a bound composite, provide `repositoryId` and `assetId` and/or `links`.
 * To create an unbound composite, provide neither `repositoryId` or `assetId`. Must provide `name` and `type`.
 *
 * @experimental
 *
 * @param {string}                  [assetId]           - Asset ID of the composite if it already exists in the cloud.
 * @param {string}                  [repositoryId]      - Repository ID of the composite if it already exists in the cloud.
 * @param {string}                  [name]              - Composite name.
 * @param {string}                  [id]                - Composite ID.
 * @param {string}                  [type]              - Content Type of the composite, once created this cannot be changed.
 * @param {Record<string, Link>}    [links]             - Links associated with the composite.
 * @param {AdobeDCXCompositeOptions}              [options]           - Additional configuration options.
 */
export declare function newDCXComposite(assetId?: string, repositoryId?: string, name?: string, id?: string, type?: string, links?: Record<string, Link>, options?: AdobeDCXCompositeOptions): AdobeDCXComposite;
/**
 * Create a new composite cloud asset at the specified path.
 *
 * <p> After creating a new, local-only composite the client must first bind it to a specific repository, path,
 * and asset id in the cloud by calling this method. If successful then the composite object's assetId property will
 * be assigned and the client is now free to upload or copy new components for the composite and call pushComposite.
 *
 * @param session               The repo session to use.
 * @param composite             New composite object whose assetId property is still undefined.
 * @param parentDir             Parent directory in which to create the composite.
 * @param relPath               Path at which new composite will be created in the cloud, relative to parentDir
 */
export declare function createComposite(session: AdobeRepoAPISession, composite: AdobeDCXComposite, parentDir: AdobeAsset, relPath: string): AdobePromise<AdobeDCXComposite, AdobeDCXError>;
/**
 * Create a new composite cloud asset at the specified path.
 *
 * <p> After creating a new, local-only composite the client must first bind it to a specific repository, path,
 * and asset id in the cloud by calling this method. If successful then the composite object's assetId property will
 * be assigned and the client is now free to upload or copy new components for the composite and call pushComposite.
 *
 * @param session               The repo session to use.
 * @param composite             New composite object whose assetId property is still undefined.
 * @param parentDir             Parent directory in which to create the composite.
 * @param relPath               Path at which new composite will be created in the cloud, relative to parentDir
 * @param respondWith           undefined
 * @param additionalHeaders     Additional headers to be applied to HTTP requests
 */
export declare function createComposite(session: AdobeRepoAPISession, composite: AdobeDCXComposite, parentDir: AdobeAsset, relPath: string, respondWith: undefined, additionalHeaders?: Record<string, string>, snapshot?: SliceableData | GetSliceCallback, snapshotSize?: number): AdobePromise<AdobeDCXComposite, AdobeDCXError>;
/**
 * Create a new composite cloud asset at the specified path and respond with the requested resource if possible.
 * <p> After creating a new, local-only composite the client must first bind it to a specific repository, path,
 * and asset id in the cloud by calling this method. If successful then the composite object's assetId property will
 * be assigned and the client is now free to upload or copy new components for the composite and call pushComposite.
 * The resolved value of the promise when a resource designator is provided is the requested resource itself.
 *
 * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/basics/create.html#alternate-form-create-with-response}
 *
 * @param session               The repo session to use.
 * @param composite             New composite object whose assetId property is still undefined.
 * @param parentDir             Parent directory in which to create the composite.
 * @param relPath               Path at which new composite will be created in the cloud, relative to parentDir
 * @param respondWith           A resource to respond with. This is useful for resolving with the repository metadata
 * @param additionalHeaders     Additional headers to be applied to HTTP requests
 *
 * @returns {AdobePromise<AdobeAsset, AdobeDCXError>}
 */
export declare function createComposite(session: AdobeRepoAPISession, composite: AdobeDCXComposite, parentDir: AdobeAsset, relPath: string, respondWith: ResourceDesignator, additionalHeaders?: Record<string, string>, snapshot?: SliceableData | GetSliceCallback, snapshotSize?: number): AdobePromise<AdobeAsset, AdobeDCXError>;
/**
 * Create a new composite cloud asset at the specified path and respond with the requested resource if possible.
 * <p> After creating a new, local-only composite the client must first bind it to a specific repository, path,
 * and asset id in the cloud by calling this method. If successful then the composite object's assetId property will
 * be assigned and the client is now free to upload or copy new components for the composite and call pushComposite.
 * The resolved value of the promise when a resource designator is provided is the requested resource itself.
 *
 * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/basics/create.html#alternate-form-create-with-response}
 *
 * @param session               The repo session to use.
 * @param composite             New composite object whose assetId property is still undefined.
 * @param parentDir             Parent directory in which to create the composite.
 * @param relPath               Path at which new composite will be created in the cloud, relative to parentDir
 * @param respondWith           A resource to respond with. This is useful for resolving with the repository metadata
 * @param additionalHeaders     Additional headers to be applied to HTTP requests
 *
 * @returns {AdobePromise<AdobeAsset, AdobeDCXError>}
 */
export declare function createComposite(session: AdobeRepoAPISession, composite: AdobeDCXComposite, parentDir: AdobeAsset, relPath: string, respondWith: ResourceDesignator, additionalHeaders?: Record<string, string>, snapshot?: SliceableData | GetSliceCallback, snapshotSize?: number): AdobePromise<AdobeAsset, AdobeDCXError>;
/**
 * Convert an HLA asset class instance, or AdobeAsset compatible data object to an AdobeDCXComposite.
 *
 * @note Does not validate that incoming asset has any specific properties.
 *
 * @param {AdobeAsset}                  asset           - Asset to convert.
 * @param {string}                      [id]            - Composite ID.
 * @param {AdobeDCXCompositeOptions}    [opts={}]       - Additional configuration options
 */
export declare function convertToDCXComposite(asset: AdobeAsset | Composite, id?: string, opts?: AdobeDCXCompositeOptions): AdobeDCXComposite;
//# sourceMappingURL=AdobeDCXComposite.d.ts.map