/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeDCXBranch, AdobeDCXElement, AdobeDCXNodeData, AdobeDCXRootNodeData, HalLink, AdobeDCXNode as IAdobeDCXNode } from '@dcx/common-types';
import DCXBranch from './AdobeDCXBranch';
import DCXElement from './AdobeDCXElement';
export interface AdobeDCXLocalNodeData {
    local?: {
        version?: number;
        change?: number;
        collaborationType?: string;
        clientDataString?: string;
        archivalState?: 'pending' | 'archived';
        manifestEtag?: string;
    };
}
/**
 * @class
 * @classdesc AdobeDCXNode represents a node of a DCX manifest.
 * <p>The constructor for AdobeDCXNode is private. Refer to {@link AdobeDCXBranch} to
 * learn how to access existing nodes or create new ones.
 * @hideconstructor
 * @param {Object}  data
 * @param {Boolean} readOnly
 * @param {Boolean} isRoot
 */
export declare class AdobeDCXNode implements IAdobeDCXNode {
    static ROOT_PATH: string;
    /** @internal  */
    _parentPath?: string;
    /** @internal  */
    _owner?: DCXBranch | DCXElement;
    /** @internal  */
    _data: (AdobeDCXNodeData | AdobeDCXRootNodeData) & AdobeDCXLocalNodeData;
    /** @internal  */
    _readOnly: boolean;
    readonly _isRoot: boolean;
    constructor(data?: AdobeDCXNodeData | AdobeDCXRootNodeData, readOnly?: boolean, isRoot?: boolean);
    get owner(): AdobeDCXElement | AdobeDCXBranch | undefined;
    /**
     * The id of the node. Must be a unique among the nodes of the composite.
     * <p>Cannot be changed for a node that is part of a branch or element.</p>
     * @memberof AdobeDCXNode#
     * @type {String}
     */
    get id(): string;
    set id(id: string);
    /**
     * The name of the node.
     *
     * @memberof AdobeDCXNode#
     * @type {String}
     */
    get name(): string | undefined;
    set name(name: string | undefined);
    /**
     * The type of the node.
     *
     * @memberof AdobeDCXNode#
     * @type {String}
     */
    get type(): string;
    set type(type: string);
    /**
     * The relationship of the node to its parent node.
     *
     * @memberof AdobeDCXNode#
     * @type {String}
     */
    get relationship(): string | undefined;
    set relationship(relationship: string | undefined);
    /**
     * The path property of the node.
     *
     * @memberof AdobeDCXNode#
     * @type {String}
     */
    get path(): string | undefined;
    set path(path: string | undefined);
    /**
     * The absolute path of the parent of the node.
     *
     * @memberof AdobeDCXNode#
     * @readonly
     * @type {String}
     */
    get parentPath(): string | undefined;
    set parentPath(_: string | undefined);
    /**
     * The absolute path of the node.
     *
     * @memberof AdobeDCXNode#
     * @readonly
     * @type {String}
     */
    get absolutePath(): string | undefined;
    set absolutePath(_: string | undefined);
    /**
     * Whether this node is the root of its branch or element.
     *
     * @memberof AdobeDCXNode#
     * @readonly
     * @type {Boolean}
     */
    get isRoot(): boolean;
    set isRoot(_: boolean);
    /**
     * Returns the link with the given relationship as a JS object or undefined if the node
     * doesn't have such a link.
     * @param   {String} relationship The relationship of the link to the node.
     * @returns {Object} The link with the given relationship as a JS object or undefined if
     *                   the node doesn't have such a link.
     */
    getLink(relationship: string): HalLink | undefined;
    /**
     * Sets the link with the given relationship to the given object.
     * @param {Object} link         A JS object representing the link.
     * @param {String} relationship The relationship of the link to the node.
     */
    setLink(link: HalLink, relationship: string): void;
    /**
     * Removes the link with the given relationship.
     * @param {String} relationship The relationship of the link to the node.
     *
     */
    removeLink(relationship: string): void;
    /**
     * Returns an array of non-standard keys that are present at this node.
     * @returns {Array} An array of all non-standard property keys.
     */
    getCustomKeys(): string[];
    /**
     * Returns the object or value for the given key.
     * @param   {String} key The custom key to look up.
     * @returns {*} The value or object for the key.
     */
    getValue<T = any>(key: string): T;
    /**
     * Returns the object or value for the given key.
     * @param {String}   key   The custom key to set the value for.
     * @param {*} value The value or object.
     */
    setValue<T = any>(key: string, value: T): void;
    /**
     * Removes the object or value for the given key.
     * @param {String} key The custom key to remove.
     */
    removeValue(key: string): void;
    /**
     * Creates and returns a deep copy of the node sans any of its components or children.
     * @returns {AdobeDCXNode} The copy.
     */
    copy(): IAdobeDCXNode;
    /**
     * Returns false if any of the properties of the given node is different from the properties
     * of this node. Recurses both data structures.
     * @param   {AdobeDCXNode} node                          The node to compare with.
     * @param   {Array}        [nodePropertiesToIgnore]      Optional. An object having the properties
     *                                                       that should not be compared for node.
     * @param   {Array}        [componentPropertiesToIgnore] Optional. An object having the properties
     *                                                       that should not be compared for components.
     * @returns {Boolean}
     */
    isEqualTo(node: IAdobeDCXNode, nodePropertiesToIgnore?: Record<string, boolean>, componentPropertiesToIgnore?: Record<string, boolean>): boolean;
    /**
     * Internal. Compares nodeData
     * @private
     * @param   {Object}  nodeData1
     * @param   {Object}  nodeData2
     * @param   {Object}  nodePropertiesToIgnore
     * @param   {Object}  componentPropertiesToIgnore
     * @returns {Boolean}
     */
    private _isEqual;
    /**
     * Verifies and sets the new data. Throws if invalid data.
     * @private
     * @param   {Object} data
     * @returns {AdobeDCXNode}
     *
     * @throws {AdobeDCXError}
     */
    private _setData;
    /**
     * Returns an error if the passed in data is not a valid node. Returns null if everything is OK.
     * @private
     * @param   {Object} data
     * @returns {AdobeDCXError | null}
     */
    private _verify;
    /**
     * Sets the dirty flag on the node's branch or element (if set)
     * @private
     */
    private _setDirty;
}
export default AdobeDCXNode;
//# sourceMappingURL=AdobeDCXNode.d.ts.map