/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeDCXBranch, AdobeDCXComposite } from '@dcx/common-types';
import { SourceAssetInfoEntry } from './AdobeDCXBranchCore';
import { DerivationType } from './util/xmp';
export interface UploadedComponentRecord {
    etag: string;
    length: number;
    version: string;
    md5: string;
    timestamp: string;
    'source-asset-info'?: any;
}
/**
 * Captures the state and progess of a composite push operation
 * which can be used to resume a failed push at a later time.
 * @private
 */
export declare class AdobeDCXPushJournal {
    private _data;
    private _waitingCallbacks;
    private _commitInProgress;
    private _needAnotherCommit;
    constructor(composite: AdobeDCXComposite);
    get compositeHref(): string;
    set compositeHref(id: string);
    get derivationType(): DerivationType | undefined;
    set derivationType(derivationType: DerivationType | undefined);
    get manifestEtag(): string | undefined;
    set manifestEtag(etag: string | undefined);
    get versionId(): string | undefined;
    set versionId(v: string | undefined);
    get currentBranchEtag(): string | undefined;
    set currentBranchEtag(etag: string | undefined);
    get changeCount(): number | undefined;
    set changeCount(change: number | undefined);
    get compositeHasBeenDeleted(): boolean;
    set compositeHasBeenDeleted(hasBeenDeleted: boolean);
    get compositeHasBeenArchived(): boolean;
    set compositeHasBeenArchived(hasBeenArchived: boolean);
    get isEmpty(): boolean;
    set isEmpty(_: boolean);
    get isComplete(): boolean;
    set isComplete(_: boolean);
    /**
     * Records the upload of the given component.
     * @internal
     * @param {String}  componentId
     * @param {String}  etag
     * @param {String}  version
     * @param {String}  md5
     * @param {Integer} length
     * @param {Object}  sourceAssetInfo
     */
    recordUploadedComponent(componentId: string, etag: string, version: string, md5: string, length: number, sourceAssetInfo?: SourceAssetInfoEntry): void;
    /**
     * Returns an array of the ids of all uploaded components.
     * @internal
     * @returns {Array}
     */
    idsOfAllUploadedComponents(): string[];
    /**
     * Returns an upload record of the given component or undefined if it has not been uploaded or
     * has aged out.
     * @param   {String}   componentId
     * @returns {Object}
     * @example
     *      {
     *           etag: componentEtag,
     *           length: componentLength,
     *           version: component.Version,
     *           md5: componentMd5,
     *           'source-asset-info': {
     *              'compositeAssetId': assetId,
     *              'componentId': componentId,
     *              'componentVersion': version
     *           }
     *      }
     */
    getRecordForUploadedComponent(componentId: string): UploadedComponentRecord | undefined;
    /**
     * Deletes the upload record for the given component.
     */
    removeRecordForUploadedComponent(componentId: string): void;
    /**
     * Applies the journaled data to the provided branch.
     */
    applyToBranch(pBranch: AdobeDCXBranch, preserveDirtyState?: boolean): void;
}
export default AdobeDCXPushJournal;
//# sourceMappingURL=AdobeDCXPushJournal.d.ts.map