/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeDCXComposite, FailedComponent, ProgressCallback } from '@dcx/common-types';
import { AdobeRepoAPISession } from '@dcx/repo-api-session';
import DCXBranch from '../AdobeDCXBranch';
import DCXComposite from '../AdobeDCXComposite';
import AdobeDCXPushJournal from '../AdobeDCXPushJournal';
/**
 * Public XferContext API.
 */
export interface AdobeXferContext {
    /**
     * Components failed during an xfer, used for pushComposite.
     * If none failed, this will be an empty array.
     */
    failedComponents: FailedComponent[];
    /**
     * Whether the xfer has been aborted.
     */
    aborted: boolean;
    /**
     * Total bytes currently transferred at a given time.
     */
    bytesTransfered: number;
    /**
     * Total estimated bytes for the xfer.
     */
    bytesTotal: number;
    /**
     * Register callback to be called after aborting xfer.
     * @param {AbortHandler} cb - The handler to be called.
     */
    onAbort: (cb: AbortHandler) => void;
    /**
     * Set a callback to be called on each progress event of the xfer.
     * Unlike onAbort, this is a single handler
     */
    onProgress: ProgressCallback | undefined;
    /**
     * Abort the xfer, canceling pending requests where possible.
     * @param {Error|string} reason - Reason for the abort, will become the error message for each canceled promise.
     */
    abort(reason?: Error | string): void;
}
export type AbortHandler = (reason?: string | Error) => void;
/**
 * R-API implementation of XferContext.
 * This implementation is private, not intended to be used directly by clients.
 *
 * Public APIs that return an XferContext-like object (for example, `AdobePromise<T, U, Context>`)
 * should use the interface `AdobeXferContext` as opposed to this class.
 *
 * Internal methods can use this to strongly-type the additional data required for the xfer operation.
 * This is done through the use of the `T` generic, which defined the type of the `_additionalData` internal property.
 */
export declare class XferContext<T = void> implements AdobeXferContext {
    readonly additionalHeaders?: Record<string, string> | undefined;
    private _aborted;
    private _bytesTransfered;
    private _abortHandlers;
    private _progressHandler?;
    /** @internal */
    _bytesTotal: number;
    /** @internal */
    _additionalData: T;
    /** @internal */
    _failedComponents: FailedComponent[];
    /** @internal */
    _journal: AdobeDCXPushJournal;
    /** @internal */
    _referenceBranch?: DCXBranch;
    /** @internal */
    _composite: DCXComposite;
    /** @internal */
    _session: AdobeRepoAPISession;
    /** @internal */
    _indeterminateTotalBytes?: boolean;
    /** @internal */
    _blockSize?: number;
    constructor(session: AdobeRepoAPISession, composite: AdobeDCXComposite, additionalData?: T, progressCb?: ProgressCallback, additionalHeaders?: Record<string, string> | undefined, blockSize?: number);
    get aborted(): boolean;
    get bytesTransfered(): number;
    get bytesTotal(): number;
    get failedComponents(): FailedComponent[];
    get hasProgressHandler(): boolean;
    set onProgress(cb: ProgressCallback | undefined);
    get onProgress(): ProgressCallback | undefined;
    onAbort(h: AbortHandler): void;
    abort(reason?: string | Error): void;
    /**
     * Report a progress event.
     *
     * If the event has an indeterminate length, the rest of the XferContext is also indeterminate.
     * This may occur in the case of BlockUpload where the size estimate by the client was wrong,
     * and there was a call to extend the transfer. At that point a client may upload unknowable
     * amount of data.
     *
     * @internal
     *
     * @param {number} incr             - Delta of bytes sent or received
     * @param {boolean} [indeterminate] - True if the total size of the transfer can not be determined
     */
    _reportProgress(incr: number, indeterminate?: boolean): void;
}
//# sourceMappingURL=XferContext.d.ts.map