/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/// <reference types="node" />
import { AdobeBlockUpload, AdobeDCXError, AdobeRepoUploadResult, AdobeResponse, AdobeUploadRecord, AdobeUploadResults, GetSliceCallback, InternalFunction } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { AdobeXferContext, XferContext } from './XferContext';
/**
 * Interface defining additional context data for upload
 * @internal
 */
export interface AdditionalDataForUpload {
    componentType: string;
    componentIsNew: boolean;
    componentId: string;
    size?: number;
    md5?: string;
    response?: AdobeResponse;
}
/**
 * Internal implementation of upload component.
 *
 * @internal
 *
 * @param {XferContext<AdditionalDataForUpload>} pushContext    - Push context, used as `this` scope for other internals.
 * @param {any} data                                            - Data or slicer function to upload
 */
export declare function _uploadComponent(uploadContext: XferContext<AdditionalDataForUpload>, dataOrSliceCallback: Buffer | ArrayBuffer | Blob | string | GetSliceCallback): AdobePromise<AdobeUploadResults, AdobeDCXError, AdobeXferContext & {
    blockUpload?: AdobeBlockUpload | undefined;
}>;
/**
 * Clean an asset from an upload results, returning the required key/values.
 * If a required property is missing, throw an error.
 *
 * @throws {AdobeDCXError}
 *
 * @private
 *
 * @returns {UploadRecord}
 */
export declare function _validateUploadResults(componentId: string, pLength: number, type: string, result: Partial<AdobeRepoUploadResult['result']>): AdobeUploadRecord;
/**
 * Internal types for testing
 *
 * @internal
 * @private
 */
export interface InternalTypes {
    _validateUploadResults: InternalFunction<typeof _validateUploadResults>;
}
/**
 * @internal
 * @private
 */
export declare const internals: InternalTypes;
//# sourceMappingURL=upload.internal.d.ts.map