# @dcx/error

This module contains the error/exception class extension used by dcx-js, as well as specific error codes and wrapping logic.

### Properties
| Property | Type | Description | Always available | Notes |
| - | - | - | - | - |
| `code` | string | Error code string as defined [below](#error-codes) | true | |
| `message` | string | Error code message as defined [below](#error-message-format) | true | |
| `_message` | string | Error code message without the code prefix | true | Internal property not exposed through type declarations, but always available. |
| `name` | string | Always `"AdobeDCXError"` | true | |
| `stack` | string | Error stack trace | true | |
| `additionalData` | object | Additional data associated with the error. | false | An AdobeDCXError may have an associated generic, `T`, in which case `additionalData` is of type `T`. Otherwise, the field may or may not contain any data at all. |
| `underlyingError` | Error \| AdobeDCXError | Error object leading to this error. | false | |
| `response` | [AdobeResponse](https://dcx.ci.corp.adobe.com/job/dcx-js-stats/dcx-js_20Docs/interfaces/_dcx_common_types.adoberesponse-2.html) | Response object if there was an HTTP request associated with the error. | false | |




For more details on available properties, see [the docs](https://dcx.ci.corp.adobe.com/job/dcx-js-stats/dcx-js_20Docs/classes/_dcx_error.adobedcxerror.html).

### Error codes
| Enum Key | Code String | Description |
| - | - | -|
| ABORTED | 'ABORTED' | Request aborted. |
| ALREADY_EXISTS | 'ALREADY_EXISTS' | Resource already Exists. |
| ASSET_NOT_FOUND | 'ASSET_NOT_FOUND' | A resource (manifest, component or rendition) could not be found. |
| COMPONENT_DOWNLOAD_ERROR | 'COMPONENT_DOWNLOAD_ERROR' | Component(s) download failure -- see error.failedComponents for more details. |
| COMPONENT_MODIFIED_ERROR | 'COMPONENT_MODIFIED_ERROR' | Component file could not be removed since it was modified -- see `error.additionalData.componentId` for the id of the component. |
| COMPONENT_UPLOAD_ERROR | 'COMPONENT_UPLOAD_ERROR' | Component(s) upload failure -- see `error.additionalData.failedComponents` for more details. |
| COMPOSITE_NOT_FOUND | 'COMPOSITE_NOT_FOUND' | A composite could not be found. |
| DELETED_COMPOSITE | 'DELETED_COMPOSITE' | Invalid operation on a deleted composite. |
| DUPLICATE_VALUE | 'DUPLICATE_VALUE' | Uniqueness constraint violated.
| EXCEEDS_QUOTA | 'EXCEEDS_QUOTA' |  Exceeds quota. |
| FILE_EXISTS_IN_CLOUD | 'FILE_EXISTS_IN_CLOUD' | A composite could not be created because a regular file already exists at the specified path
| FORBIDDEN | 'FORBIDDEN' | Forbidden (403) |
| INCOMPLETE_COMPOSITE | 'INCOMPLETE_COMPOSITE' | The manifest push failed due to having components in it that do not exist in cloud storage. pass this error to the `DCXBranch.getMissingComponentsFromError` method to retrieve the components in the manifest which triggered the error. 
| INSECURE_REDIRECT | 'INSECURE_REDIRECT' | Request containing Authorization header redirected to HTTP. |
| INVALID_DATA | 'INVALID_DATA' | Data is invalid. Usually this means that a document read from disk or from an http request is bad. |
| INVALID_JSON | 'INVALID_JSON' | Parsing JSON data has failed. |
| INVALID_LINKS | 'INVALID_LINKS' | Links are invalid, either missing or do not contain the required relation. Used with leaf functions when they don't receive valid links.
| INVALID_PARAMS | '' | The parameters passed to a function are not as expected. |
| INVALID_STATE | 'INVALID_STATE' | An object is not in the expected state. |
| NETWORK_ERROR | 'NETWORK_ERROR' | Network error
| NO_BASE_BRANCH_DATA | 'NO_BASE_BRANCH_DATA' | Trying to invoke functionality that requires that AdobeDCX being initialized with the xhrBaseBranchSupport option. |
| NO_COMPOSITE | 'NO_COMPOSITE' | No composite. Possibly deleted. |
| NOT_FOUND | 'NOT_FOUND' | Generic not found error.
| NOT_IMPLEMENTED | 'NOT_IMPLEMENTED' | Unimplemented server request or unimplemented client method. |
| OUT_OF_SPACE | 'ENOSPC' | A file operation failed because the disk is full. We use the POSIX error code returned by the file system so that we do not have to wrap/translate. |
| READ_ONLY | 'READ_ONLY' | Trying to modify an immutable object or property. |
| RETRYABLE_SERVER_ERROR | 'RETRYABLE_SERVER_ERROR' | Retryable server error |
| SERVICE_IS_INACTIVE | 'SERVICE_IS_INACTIVE' | HTTP session is in inactive state. |
| TERMINATED_INPUTSTREAM | 'TERMINATED_INPUTSTREAM' | Input stream terminated abnormaly |
| TIMED_OUT | 'TIMED_OUT' | Timed-out request |
| TOO_MANY_REDIRECTS | 'TOO_MANY_REDIRECTS' | Request was redirected over set maximum redirects. |
| UNAUTHORIZED | 'UNAUTHORIZED' | Unauthorized (401) |
| UNEXPECTED | 'UNEXPECTED' | Unexpected failure, usually a problem acquiring a local resource such as a file.
| UNEXPECTED_RESPONSE | 'UNEXPECTED_RESPONSE' | Unexpected Response |
| UPDATE_CONFLICT | 'UPDATE_CONFLICT' | Update Conflict |
| WRONG_ENDPOINT | 'WRONG_ENDPOINT' | Trying to access an asset from a different endpoint |

### Error message format
When an AdobeDCXError instance is printed to a console, it will print in a similar format to the native JS Error prototype: 

```sh
<name>: [<code>] <message>
```

For AdobeDCXError instances with code strings, this leads to a the output:
```js
AdobeDCXError: [CODE_STRING] MESSAGE_STRING
```

If no error code string exists (or the error code string is empty), the square brackets are omitted:
```js
AdobeDCXError: Something went wrong.
```