/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/**
 * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/single.html#problem-types RAPI Spec: Problem Types}
 */
export declare enum ProblemTypes {
    ACCESS_DENIED = "http://ns.adobe.com/adobecloud/problem/accessdenied",
    ASSET_LOCKED = "http://ns.adobe.com/adobecloud/problem/assetlocked",
    ASSET_MOVED = "http://ns.adobe.com/adobecloud/problem/assetmoved",
    ASSET_NAME_CONFLICT = "http://ns.adobe.com/adobecloud/problem/assetnameconflict",
    ASSET_NAME_INVALID = "http://ns.adobe.com/adobecloud/problem/assetnamenotvalid",
    ASSET_NOT_FOUND = "http://ns.adobe.com/adobecloud/problem/assetnotfound",
    ASSET_STATE_NOT_ALLOWED = "http://ns.adobe.com/adobecloud/problem/assetstatenotallowed",
    BAD_REQUEST = "http://ns.adobe.com/adobecloud/problem/badrequest",
    BULK_REQUEST_NOT_ATTEMPTED = "http://ns.adobe.com/adobecloud/problem/bulkrequestnotattempted",
    COMPOSITE_INTEGRITY = "http://ns.adobe.com/adobecloud/problem/compositeintegrity",
    DCX_VALIDATION = "http://ns.adobe.com/adobecloud/problem/dcxvalidation",
    DIRECTORY_NOT_EMPTY = "http://ns.adobe.com/adobecloud/problem/directorynotempty",
    EMBED_INVALID = "http://ns.adobe.com/adobecloud/problem/embedinvalid",
    EMBED_TOO_LARGE = "http://ns.adobe.com/adobecloud/problem/embedtoolarge",
    ENCRYPTION_KEY_INACCESSIBLE = "http://ns.adobe.com/adobecloud/problem/encryptionkeyinaccessible",
    INVALID_FRAGMENT = "http://ns.adobe.com/adobecloud/problem/invalidfragment",
    LIMIT_CHILDREN_COUNT = "http://ns.adobe.com/adobecloud/problem/limit/childrencount",
    LIMIT_COMPONENT_COUNT = "http://ns.adobe.com/adobecloud/problem/limit/componentcount",
    LIMIT_EMBED_SELECTOR_COUNT = "http://ns.adobe.com/adobecloud/problem/limit/embedspecifierselectorcount",
    LIMIT_MILESTONE_COUNT = "http://ns.adobe.com/adobecloud/problem/limit/milestonecount",
    LIMIT_MILESTONE_LABEL_LENGTH = "http://ns.adobe.com/adobecloud/problem/limit/milestonelabellength",
    LIMIT_NAME_LENGTH = "http://ns.adobe.com/adobecloud/problem/limit/namelength",
    LIMIT_OPERATION_COUNT = "http://ns.adobe.com/adobecloud/problem/limit/operationcount",
    LIMIT_PATH_SEGMENT_COUNT = "http://ns.adobe.com/adobecloud/problem/limit/pathsegmentcount",
    LIMIT_RESOURCE_COUNT = "http://ns.adobe.com/adobecloud/problem/limit/resourcecount",
    LIMIT_RESOURCE_SIZE = "http://ns.adobe.com/adobecloud/problem/limit/resourcesize",
    /**
     * When user have zero storage assigned to them
     */
    NOT_ENTITLED = "http://ns.adobe.com/adobecloud/problem/notentitled",
    OPERATION_FAILED = "http://ns.adobe.com/adobecloud/problem/operationfailed",
    OPERATION_TARGET_CONFLICT = "http://ns.adobe.com/adobecloud/problem/operation/targetconflict",
    QUOTA_EXCEEDED = "http://ns.adobe.com/adobecloud/problem/quotaexceeded",
    REPOSITORY_NOT_FOUND = "http://ns.adobe.com/adobecloud/problem/repositorynotfound",
    RESOURCE_BLOCKED = "http://ns.adobe.com/adobecloud/problem/resourceblocked",
    RESOURCE_NOT_ALLOWED = "http://ns.adobe.com/adobecloud/problem/resourcenotallowed",
    RESOURCE_NOT_FOUND = "http://ns.adobe.com/adobecloud/problem/resourcenotfound",
    RESOURCE_NOT_READY = "http://ns.adobe.com/adobecloud/problem/resourcenotready",
    RESPONSE_TOO_LARGE = "http://ns.adobe.com/adobecloud/problem/responsetoolarge",
    USER_BLOCKED = "http://ns.adobe.com/adobecloud/problem/userblocked",
    VERSION_NOT_FOUND = "http://ns.adobe.com/adobecloud/problem/versionnotfound",
    PARTIAL_ASSET = "http://ns.adobe.com/adobecloud/problem/partialasset"
}
//# sourceMappingURL=problems.d.ts.map