"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var e=require("@dcx/error"),t=require("@dcx/logger"),s=require("@dcx/promise"),r=require("@dcx/util"),i=require("./defaults-74e65a09.js");function o(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var n=o(s);const h=t.newDebug("dcx:http:auth");class a{constructor(e,t,s){this._authToken=e,this._apiKey=t,this._pendingAuth=!1,this._hasBaseRefreshCb=!1,this._authListeners=[],this._persistentListeners=[],this._authenticationAllowList=["adobe.com","adobe.io","adobelogin.com","fotolia.net"],this._authTokenScheme="Bearer",r.validateParams(["authToken",e,"string",!0],["apiKey",t,"string",!0],["refreshCb",s,"function",!0]),s&&(this._hasBaseRefreshCb=!0,this.onChange(((e,t)=>{"unauthenticated"===e&&s.call(null,t)}),!0)),e&&t||(h("init unauthenticated"),this._pendingAuth=!0,setTimeout((()=>{h("after tick",this._pendingAuth),this._pendingAuth&&this.refreshAuth()})))}get authenticationAllowList(){return this._authenticationAllowList}set authenticationAllowList(t){if(!Array.isArray(t))throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Expecting an array.");this._authenticationAllowList=t}get isNoAuthMode(){return!this._hasBaseRefreshCb}set isNoAuthMode(e){this._hasBaseRefreshCb=!e}get apiKey(){return this._apiKey}get authToken(){return this._authToken}get authTokenScheme(){return this._authTokenScheme}set authTokenScheme(e){this._authTokenScheme=e}setAuthToken(e){h("setAuthToken"),this._authToken=e,this._pendingAuth=!1,this._authChanged("updated")}setApiKey(e){this._apiKey=e}resume(){h("resume()"),this._pendingAuth=!1,this._authChanged("updated")}get pendingAuth(){return this._pendingAuth}onChange(e,t=!1){h("onChange, persistent:",t);const s=this._authListeners.push(e)-1;return t&&this._persistentListeners.push(s),()=>{try{t&&(this._persistentListeners=this._persistentListeners.filter((e=>e!==s))),delete this._authListeners[s]}catch(e){}}}clearListeners(e=!1){if(h("clearListeners, persistent:",e),!0===e)return this._authListeners=[],void(this._persistentListeners=[]);this._authListeners=this._authListeners.map(((e,t)=>{if(this._persistentListeners.includes(t))return e}))}get refreshPromise(){return this._refreshPromise}async _authChanged(e){h("authChanged",e),this._pendingAuth="unauthenticated"===e,queueMicrotask((async()=>{const t=[];this._authListeners.map((s=>{if("function"==typeof s){const r=s.call(null,e,this);r&&"object"==typeof r&&r.then&&t.push(r)}})),await Promise.all(t),"updated"===e&&this._resolveRefresh()}))}_resolveRefresh(){h("_resolveRefresh"),this._refreshResolve&&this._refreshResolve(this.getAuthData()),this._refreshResolve=void 0,this._refreshPromise=void 0}refreshAuth(){return h("refreshAuth"),this._refreshPromise||(this._refreshPromise=new Promise((e=>{this._refreshResolve=e})),this._authChanged("unauthenticated")),this._refreshPromise}getAuthData(){return{authToken:this._authToken,apiKey:this._apiKey}}async getAuth(){return Promise.resolve(this.getAuthData())}isAuthorizedURL(e){const t=r.getDomainFromURL(e);return this._authenticationAllowList.includes(t)}logout(){h("logout"),this._apiKey=void 0,this._authToken=void 0,!1===this._pendingAuth&&(this._pendingAuth=!0,this._authChanged("unauthenticated"))}applyAuthHeaders(e,t){const s={"x-api-key":void 0,authorization:void 0};return this.isAuthorizedURL(e)&&(null!==t["x-api-key"]&&this.apiKey&&(s["x-api-key"]=this.apiKey),null!==t.authorization&&this.authToken&&(s.authorization=(this.authTokenScheme?`${this.authTokenScheme} `:"")+this.authToken)),t=r.pruneUndefined({...t,...s})}}const u=t.newDebug("dcx:http:xhr");let d;if(r.isNode())d=require("./XhrNode").XhrNode;else if(d="undefined"!=typeof window?window.XMLHttpRequest:XMLHttpRequest,null==d)throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_STATE,"XMLHttpRequest module not found.");const _={NO_ERROR:"",ABORTED:e.ErrorCodes.ABORTED,NETWORK:e.ErrorCodes.NETWORK_ERROR,TIMEOUT:e.ErrorCodes.TIMED_OUT,TOO_MANY_REDIRECTS:e.ErrorCodes.TOO_MANY_REDIRECTS,INSECURE_REDIRECT:e.ErrorCodes.INSECURE_REDIRECT};class c{constructor(t={}){this._autoParseJson=!1,this._bytesReported=0,this._errorCode=_.NO_ERROR,this._isFetchRequest=!1,this._fetchAbort=()=>{},this._preferFetch=!1,this._sent=!1,this.headers={},this.responseType="text",this._progressListeners=[];const{forceXhr:s,preCallback:r,postCallback:o,timeout:n,preferFetch:h}=t;this._preCallback=r,this._postCallback=o,this._timeout=null==n?i.DEFAULT_TIMEOUT:n,this._xhr=s?new s:new d,this._xhr.timeout=this._timeout,this._preferFetch=!0===h,this._fetch=t.fetch?t.fetch:"undefined"!=typeof window&&"fetch"in window&&"function"==typeof window.fetch?window.fetch.bind(window):"undefined"!=typeof self&&"fetch"in self&&"function"==typeof self.fetch?self.fetch.bind(self):"undefined"!=typeof global&&"fetch"in global&&"function"==typeof global.fetch?global.fetch.bind(global):void 0,this._parseFetchResponse=this._parseFetchResponse.bind(this),this.onProgress=this.onProgress.bind(this),this._autoParseJson=null==t.autoParseJson||t.autoParseJson,t.additionalNodeOptions&&this._xhr.setNodeOptions&&this._xhr.setNodeOptions(t.additionalNodeOptions),this._promise=new Promise((t=>{this._resolve=t,this._xhr.addEventListener("abort",(()=>{u("aborted",this._errorCode,this._timeout),this._errorCode=this._errorCode||_.ABORTED,this._finalize()})),this._xhr.addEventListener("error",(t=>{u("err",this._errorCode,t,this._xhr.status,this._timeout),this._underlyingError=t;switch(t?t.code:void 0){case"ERR_FR_TOO_MANY_REDIRECTS":this._errorCode=_.TOO_MANY_REDIRECTS;break;case e.AdobeDCXError.INSECURE_REDIRECT:this._errorCode=_.INSECURE_REDIRECT;break;case _.TIMEOUT:this._errorCode=_.TIMEOUT;break;default:this._errorCode=_.NETWORK}this._finalize()})),this._xhr.addEventListener("load",(()=>{u("load"),this._estimatedTotalBytes&&this._estimatedTotalBytes>this._bytesReported&&this._notifyProgressListeners(this._estimatedTotalBytes,this._estimatedTotalBytes,!1),this._finalize()})),this._xhr.addEventListener("timeout",(()=>{u("timeout",this._timeout),this._errorCode=_.TIMEOUT,this._finalize()}))}))}get xhr(){return this._xhr}async _parseFetchResponse(e){if(204===e.status)return e;if("chunked"===e.headers.get("transfer-encoding")||parseInt(e.headers.get("content-length")||"0")>0)switch(this.responseType){case"json":r.isJsonContentType(e.headers.get("content-type")||"")&&(this._fetchBodyAsResponseType=await e.json());break;case"arraybuffer":this._fetchBodyAsResponseType=await e.arrayBuffer();break;case"blob":this._fetchBodyAsResponseType=await e.blob();break;case"text":this._fetchBodyAsResponseType=await e.text();break;case"void":break;case"buffer":case"defaultbuffer":this._fetchBodyAsResponseType=await e.arrayBuffer().then((e=>new Uint8Array(e)))}return"stream"===this.responseType&&(this._fetchBodyAsResponseType=e.body),e}_shouldAutoParseResponse(){const e=this._errorCode===_.NO_ERROR&&this._sent&&!this._isFetchRequest&&"text"===this._xhr.responseType&&this._autoParseJson&&"string"==typeof this._xhr.response&&this._xhr.response.length<102400&&r.isJsonContentType(this.getResponseHeader("content-type"));return u("_shouldAutoParseResponse()",e),e}_fetchWithTimeout(t,s={}){if("function"!=typeof this._fetch)throw new e.DCXError(e.DCXError.UNEXPECTED,"fetch method not found but was invoked");const{timeout:r,...i}=s;this._isFetchRequest=!0;const o=t=>()=>{this._errorCode=this._errorCode||_.TIMEOUT,t(new e.DCXError(e.DCXError.TIMED_OUT,"request aborted due to timeout")),this._finalize()};if("function"!=typeof AbortController)return new Promise((async(e,s)=>{this._timeoutTimeout=setTimeout(o(s),r);const n=await this._fetch(t,i);return clearTimeout(this._timeoutTimeout),this._parseFetchResponse(n).then(e)})).finally((()=>{clearTimeout(this._timeoutTimeout)}));const n=new AbortController;return this._timeoutTimeout=setTimeout(o(n.abort.bind(n)),r),this._fetchAbort=()=>{this._errorCode=this._errorCode||_.ABORTED,n.abort(),this._finalize()},this._fetch(t,{signal:n.signal,...i}).then(this._parseFetchResponse).finally((()=>{clearTimeout(this._timeoutTimeout)}))}_finalize(){if(u("_finalize",this._xhr.status,this._errorCode),this._shouldAutoParseResponse())try{const e=JSON.parse(this._xhr.response);this._autoParsedResponse=e,this._xhr.responseType="json"}catch(e){}this._postCallback&&this._postCallback(this),this._timeoutTimeout&&clearTimeout(this._timeoutTimeout),this._progressListeners=[],this._resolve(this)}_validateResponseType(t){if("buffer"===t){if("function"!=typeof Buffer)throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_PARAMS,"No Buffer class")}else if("blob"===t){if("function"!=typeof Blob)throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_PARAMS,"No Blob class")}else if("text"!==t&&"json"!==t&&"arraybuffer"!==t&&"stream"!==t)throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_PARAMS,"Unsupported response type");return t.toLowerCase()}send(t,s,o,n={},h="text",a={}){if(u("send"),this._sent)throw new Error("Xhr already sent");this.href=t,this.method=s.toUpperCase(),this.body=o,this.body?this._estimatedTotalBytes=this.body.byteLength||this.body.length||this.body.size:this._estimatedTotalBytes=Number.MAX_SAFE_INTEGER;const d=e=>{u(`progress ${e.loaded}/${e.total}`),r.isNode()?this._bytesReported+=e.loaded:this._bytesReported=e.loaded,e.lengthComputable?(this._estimatedTotalBytes=e.total,this._notifyProgressListeners(this._bytesReported,this._estimatedTotalBytes??1/0,!1)):this._estimatedTotalBytes&&this._estimatedTotalBytes>this._bytesReported&&this._notifyProgressListeners(this._bytesReported,this._estimatedTotalBytes||e.total,!0)};["POST","PUT","PATCH"].includes(this.method)&&this._xhr.upload?this._xhr.upload.onprogress=d:this._xhr.addEventListener("progress",d),this._timeout=a.timeout||this._timeout||i.DEFAULT_TIMEOUT,u("setting timeout",this._timeout),this._xhr.timeout=this._timeout,h&&(h=this._validateResponseType(h),u("responseType: ",h),this.responseType="buffer"===h?"arraybuffer":"stream"===h?"stream":"void"===h?"text":h);const _=r.normalizeHeaders(n);if(this.headers=_,this.href.startsWith("http:")&&null!==this.headers.authorization)throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_PARAMS,"Must not send auth token over unsecured connection");if(this._preCallback&&this._preCallback(this),(this._preferFetch||"stream"===h)&&"function"==typeof this._fetch)return this._xhr.responseType=this.responseType,this._promise=new Promise((e=>{this._resolve=e,this._fetchWithTimeout(this.href,{body:["GET","HEAD"].includes(this.method.toUpperCase())?void 0:o,credentials:a.withCredentials?"include":void 0,headers:_,method:this.method,timeout:this._timeout}).then((e=>{this._fetchResponse=e,this._finalize()})),this._sent=!0})),this._promise;this._xhr.open(this.method,this.href,!0),this._xhr.responseType=this.responseType;for(const[e,t]of Object.entries(_))this._xhr.setRequestHeader(e,t);return null!=a.withCredentials&&(this._xhr.withCredentials=a.withCredentials),null!=o?this._xhr.send(o):this._xhr.send(),this._sent=!0,this._promise}abort(){if(u("abort()"),!this._sent)throw new Error("Cannot abort before sending.");this._isFetchRequest?this._fetchAbort():this._xhr.abort()}getResponseHeader(e){if(!this._sent)throw new Error("Cannot getResponseHeader before sending.");const t=e.toLowerCase(),s=this.getAllResponseHeaders();if(t in s)return s[t]}getAllResponseHeaders(){if(!this._sent)throw new Error("Cannot getAllResponseHeaders before sending.");if(this._parsedResponseHeaders)return this._parsedResponseHeaders;const e=this._isFetchRequest?r.objectFromEntries(this._fetchResponse?.headers.entries()??[]):this._xhr.getAllResponseHeaders();return this._parsedResponseHeaders="string"==typeof e?r.parseHeaders(e):r.normalizeHeaders(e),this._parsedResponseHeaders}isError(){if(!this._sent)throw new Error("Cannot check isError before sending.");return this._errorCode!==_.NO_ERROR}isAborted(){if(!this._sent)throw new Error("Cannot check isAborted before sending.");return this._errorCode===_.ABORTED}isTimedOut(){if(!this._sent)throw new Error("Cannot check isTimedOut before sending.");return this._errorCode===_.TIMEOUT}isSent(){return this._sent}getErrorCode(){return this._errorCode}getStatus(){if(!this._sent)throw new Error("Cannot getStatus before sending.");return this._fetchResponse?this._fetchResponse.status:this._xhr.status}getResponse(){if(!this._sent)throw new Error("Cannot getResponse before sending.");return this._response||(this._response={statusCode:this.getStatus(),headers:this.getAllResponseHeaders(),responseType:this._autoParsedResponse?"json":this.responseType,response:this.getResponseData(),message:this._isFetchRequest?this._fetchResponse?.statusText||"":this._xhr.statusText,xhr:this},this._autoParsedResponse&&(this._response.originalResponseData=this._xhr.response)),this._response}toJSON(){return{statusCode:this.getStatus(),headers:this.getAllResponseHeaders(),responseType:this._autoParsedResponse?"json":this.responseType,response:this.getResponseData(),message:this._xhr.statusText}}async getResponseDataAsJSON(){try{if(this._fetchResponse)return await this._fetchResponse.json();if(this._autoParsedResponse)return this._autoParsedResponse;if("json"===this._xhr.responseType){if("string"==typeof this._xhr.response)return JSON.parse(this._xhr.response);if(null===this.xhr.response&&["application/problem+json","application/json"].includes(this.xhr.getResponseHeader("content-type")))throw new e.DCXError(e.DCXError.UNEXPECTED,"Unexpected response type");return this.xhr.response}let t=this._xhr.response;if("text"===this._xhr.responseType&&null!==this._xhr.responseText)t=this._xhr.responseText;else if("arraybuffer"===this._xhr.responseType)t=r.arrayBufferToString(this._xhr.response);else{if("blob"===this._xhr.responseType&&(t instanceof Blob||r.isFunction(t.text)))return JSON.parse(await t.text());"stream"===this.responseType?await new Promise(((s,r)=>{if(t="","function"==typeof this.xhr.response.on)return this.xhr.response.on("data",(e=>{t+=e})),this.xhr.response.on("end",s),void this.xhr.response.on("error",r);if("string"==typeof this.xhr.response)return s(t=this.xhr.response);throw new e.DCXError(e.DCXError.UNEXPECTED,"Unexpected response type")})):t=this._xhr.responseText?this._xhr.responseText:t}return"string"==typeof t?JSON.parse(t):t}catch(t){throw new e.DCXError(e.DCXError.INVALID_JSON,"Could not parse response as JSON",t,this.toJSON())}}getResponseData(){if(!this._sent)throw new Error("Cannot getResponseData before sending.");return this._isFetchRequest&&this._fetchBodyAsResponseType?this._fetchBodyAsResponseType:this._autoParsedResponse||this._xhr.response}onProgress(e){const t=this._progressListeners.push(e)-1;return()=>{try{delete this._progressListeners[t]}catch(e){}}}_notifyProgressListeners(e,t,s){this._progressListeners.map((r=>r&&r.call&&r.call(null,e,t,s)))}}const l=t.newDebug("dcx:http:backoff");function p(s,i,o,n={},h,a={},u=!1){const{disableRetry:d=!1,retryNetworkError:p=!0,responseType:f="text",authCallback:g=null,progressListeners:y=[],initialWait:R=2e3,maxWait:m=32e3,preCallback:E,postCallback:T,preScheduleCallback:C,postScheduleCallback:b,preferRetryAfterHeader:w=!0,pollCodes:A=[],pollHeader:v,pollMethod:P="get"}=a;let{retryCodes:x=[],timeoutAfter:O=72e3}=a;x=u?[...A,...x]:d||r.isReadableStream(o)?[]:a.retryCodes||r.DEFAULT_RETRY_CODES,l("retry codes",x);const D=a.increase||((e,t,s)=>1===e?s:t*t>m?m:t*t);let k=0,q=0,S=!1;const N=r.now();let X,L,I,U,H=r.now(),B=0,F=!1,M=!1;const j=[];let V;function J(){l("getSnapshot()",S,k,r.now(),H,B);const e=S||null!=X?0:k-(r.now()-H);let t=B;t+=S?r.now()-H:0;const s=(X||r.now())-N;return{count:q,canceled:F,timedOut:M,requests:j,duration:s,totalWaited:t,requestPending:S,waitingFor:e}}function Q(){const e=D(q,k,R);return Math.min(e,m)}function z(e){if(e)return t=>e(t,J())}function W(e){const t=e.getResponseHeader("retry-after");if(w&&t){if(isNaN(t)){const e=Date.parse(t)-Date.now();return l("nextWait from retry-after",e),e<0?Q():e}return 1e3*parseInt(e.getResponseHeader("retry-after"))}}async function K(d=k){if(B>=O)return l("timed out",B,O),M=!0,L(U);H=r.now(),C&&await C(J()),l("retry in ",d),V=setTimeout((()=>{l("retry start"),t.log(`Request: ${i.toUpperCase()} ${s} ${n?.["x-request-id"]??""}`),S=!0,B+=d,U=new c({...a,timeout:h,preCallback:z(E),postCallback:z(T)}),j.push(U),q++;for(const e of y)U.onProgress(e);U.send(s,i,o,n,f).then((async h=>{if(t.log(`Response: ${i.toUpperCase()} ${s} ${h.headers?.["x-request-id"]} ${h.getStatus()}`),S=!1,!(h.isError()||r.checkRetriable(h.getStatus(),x)||401===h.getStatus()&&null!=g||"string"==typeof v&&null!=A&&r.checkRetriable(h.getStatus(),A)))return X=r.now(),L(h);if(h.isAborted()||F)return X=r.now(),F=!0,L(h);if(!u&&"string"==typeof v&&null!=A&&r.checkRetriable(h.getStatus(),A)){const e=h.getResponseHeader(v.toLowerCase());if(e){u=!0,s=e,i=P,o=void 0,x=[...x,...A],B=0,O*=3;const t=h.getResponseHeader("retry-after");if(w&&t){const e=W(h);if(null!=e)return k=e,K(k)}return K(0)}}if(401===h.getStatus()){if(g){try{n=await g(s,n)}catch(t){return I(new e.DCXError(e.DCXError.UNAUTHORIZED,"Authentication Failed",h))}return B+=r.now()-H,K(0)}return X=r.now(),I(new e.DCXError(e.DCXError.UNAUTHORIZED,"Authentication Failed",h))}if(r.checkRetriable(h.getStatus(),x)||p&&h.getErrorCode()===e.ErrorCodes.NETWORK_ERROR){const e=h.getResponseHeader("retry-after");if(w&&e){const e=W(h);if(null!=e)return k=e,K(k)}return k=Q(),K(k)}return X=r.now(),L(h)}))}),d),b&&await b(J())}const $=new Promise(((e,t)=>{L=e,I=t,K(0)}));return{getPromise:()=>$,cancel:function(){l("cancel()"),F=!0,null!=U&&U.abort(),S||(l("abort"),clearTimeout(V),L({getErrorCode:()=>_.ABORTED}))},onProgress:function(e){if(!y.includes(e))return y.push(e),null!=U?U.onProgress&&U.onProgress(e):void 0},getSnapshot:J}}class f{constructor(e,t,s,r,i="text",o,n,h={}){const{descriptor:a}=h;delete h.descriptor;const{cancel:u,getPromise:d,onProgress:_,getSnapshot:c}=p(e,t,s,r,h.timeout,{...h,responseType:i,authCallback:n,...h.retryOptions,descriptor:a,forceXhr:h.forceXhr,autoParseJson:h.autoParseJson});this.onProgress=_,"function"==typeof o&&_(((e,t)=>o("progress",{total:t,sentOrReceived:e}))),this._cancel=u,this._promise=d(),this._getSnapshot=c}getSnapshot(){return this._getSnapshot()}getPromise(){return this._promise}cancel(e){this._cancel(e)}}const g=t.newDebug("dcx:http:req");class y{constructor(t){if(this._pausable=!1,this._listeners={progress:[],cancel:[]},this._isStatusValid=t.isStatusValid||e._defaultStatusValidator,this._isExternalRequest=t.isExternalRequest,this._authProvider=t.authProvider,this._id=t.id,this._descriptor=t.descriptor,t.descriptor&&t.descriptor.progress){const e=t.descriptor.progress;this.on("progress",(({sentOrReceived:t,total:s})=>{e.call(void 0,t,s)}))}const s=this._authProvider.applyAuthHeaders(t.url,r.normalizeHeaders(t.headers||{}));this._isExternalRequest&&y._internalOnlyHeaders.forEach((e=>delete s[e])),this._networkRequest=new f(t.url,t.method,t.body,s,t.responseType,t.descriptor?.progress?this._emit.bind(this):void 0,this._getAuthCb(),t),this._promise=this._networkRequest.getPromise().then((s=>{const r=s.getErrorCode(),i=r||this._isStatusValid(s.getStatus(),s.getResponse());if(r||!0!==i){if(r===_.ABORTED)throw new e.DCXError(e.DCXError.ABORTED,"Aborted");if(r===_.NETWORK)throw new e.DCXError(e.DCXError.NETWORK_ERROR,"Network error",void 0,s.getResponse());if(r===_.TIMEOUT)throw new e.DCXError(e.DCXError.TIMED_OUT,"Timeout",void 0,s.getResponse());if(i instanceof e.DCXError||i instanceof Error)throw new e.DCXError(i.code||e.DCXError.UNEXPECTED_RESPONSE,i._message||i.message,i.underlyingError,s.getResponse());throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"Unexpected response",void 0,s.getResponse())}const o=this._networkRequest.getSnapshot().requests;return g("resolve",t.id),{...s.getResponse(),xhr:o[o.length-1]}})).catch((e=>{throw g("reject",t.id),e}))}get id(){return this._id}get descriptor(){return this._descriptor}_getAuthCb(){if(!this._authProvider.isNoAuthMode)return this._authCb.bind(this)}_authCb(t,s){return g("_authCb()"),this._authProvider.isAuthorizedURL(t)?this._authProvider.refreshAuth().then((()=>this._authProvider.applyAuthHeaders(t,s))):Promise.reject(new e.DCXError(e.DCXError.UNAUTHORIZED,"URL is not part of authenticationAllowList.",void 0,void 0,{url:t}))}_emit(e,t){this._listeners[e].map((e=>e.call(null,t)))}getPromise(){return this._promise}cancel(e){return this._networkRequest.cancel(e)}on(e,t){"progress"===e&&0===this._listeners[e].length&&this._networkRequest?.onProgress(((t,s)=>this._emit(e,{total:s,sentOrReceived:t}))),this._listeners[e].push(t)}}y._internalOnlyHeaders=["x-request-id","x-api-key","authorization"];const R=e=>new y(e),m=t.newDebug("dcx:http:map");class E{constructor(){this._map=new Map}addRequest(e,t){return m("addRequest()",e),this._map.set(e,t),t.getPromise().then((t=>{m("then",e),this._map.delete(e)})).catch((t=>{m("catch",e,t),this._map.delete(e)})),e}get(e){return this._map.get(e)}get length(){return this._map.size}has(e){return this._map.has(e)}removeById(e){const t=this._map.get(e);t&&this.remove(t)}remove(e,t){return e&&e.cancel&&e.cancel(t)}clear(e){this._map.forEach((t=>{this.remove(t,e)})),this._map.clear()}removeAllWithToken(e){this._map.forEach((t=>{t.descriptor.token===e&&this.remove(t)}))}}const T=t.newDebug("dcx:http:q"),C=e=>"head"===e.method.toLowerCase();class b{constructor(){this._queue=[],this._later={},this._headEndPtr=0,this._isPriority=C,this._usePriority=!1}async push(e,t,s){let r;const i=new Promise((e=>{r=e}));if("number"!=typeof t||t<=0){const t={descriptor:e,notifySent:e=>r(e),notifyCanceled:this._notifyCanceled(r)};return this._push(t),i}const{id:o}=e,n=setTimeout((()=>{this._ready(o)}),t),h=e=>r(e);return this._later[o]={readyTimeout:n,wait:t,descriptor:e,notifySent:h,notifyCanceled:this._notifyCanceled(r),notifyReady:()=>{s&&s.call(null,{wait:t,descriptor:e,notifySent:h})}},i}_notifyCanceled(e){return t=>{if(!t)return e({canceled:!0});e({canceled:!0,error:t})}}_push(e){this._usePriority&&this._isPriority(e.descriptor)?this._queue.splice(this._headEndPtr++,0,e):this._queue.push(e)}remove(e){if(e.id in this._later)return T("remove from later",e.id),this._remove(e.id);const t=this._indexOf(e);return T("remove from q",t),t>=0?this._remove(t):void 0}_remove(e,t){if(T("_remove",e),"string"==typeof e){const s=this._later[e];return s.notifyCanceled.call(null,t),s.readyTimeout&&clearTimeout(s.readyTimeout),void delete this._later[e]}this._queue[e].notifyCanceled.call(null,t),this._queue.splice(e,1),e<this._headEndPtr&&this._headEndPtr--}_indexOf(e){const t=!!e.method,s=t&&this._usePriority&&this._isPriority(e),r=s?this._headEndPtr:this._queue.length,i=s||!t?0:this._headEndPtr;for(let t=i;t<i+r;t++)if(e.id===this._queue[t].descriptor.id)return t;return-1}exists(e){return e.id in this._later||this._indexOf(e)>=0}_ready(e){const t=this._later[e],s=t.notifyReady;delete this._later[e],delete t.notifyReady,delete t.readyTimeout,delete t.wait,this._push(t),"function"==typeof s&&s.call(null)}pop(){const e=this._queue.shift();return this._headEndPtr>0&&this._headEndPtr--,e}get length(){return T("length: ",this._queue.length,Object.keys(this._later).length),this._queue.length+Object.keys(this._later).length}clear(e){for(let t=this._queue.length-1;t>=0;t--)this._remove(t,e);this._queue=[];const t=Object.keys(this._later);for(const s in t){const r=t[s];this._remove(r,e)}this._later={}}removeAllWithToken(e){for(let t=this._queue.length-1;t>=0;t--)this._queue[t].descriptor.token===e&&this._remove(t);const t=Object.keys(this._later);for(const s in t){const r=t[s];this._later[r].descriptor.token===e&&this._remove(r)}}}const w=t.newDebug("dcx:http:service"),A=3e5;class v{constructor(e,t={}){this.name="AdobeHTTPService",this._requestQueue=new b,this._requestsOutstanding=new E,this._authProvider=void 0,this._isActive=!0,this._preferFetch=!1,this._handlesRedirects=!0,this._withCredentials=!1,this._additionalNodeOptions={},this._retryOptions={},this._serviceGuid=r.generateUuid(),this._reqNum=0,this.featureFlags={},e instanceof a||r.isObject(e)&&r.isAnyFunction(e.onChange)?this._authProvider=e:r.isAnyFunction(e)&&(t.useAuthProvider?(this._authProvider=new a(void 0,void 0,e),this._waitingForAuthentication=!0):(this._authProvider=new a(void 0,void 0,(()=>e.call(null,this))),this._waitingForAuthentication=!0)),this._authProvider?this._authProvider.onChange(this._onAuthChange.bind(this)):(this._authProvider=new a,this._authProvider.resume()),this._maxOutstanding=t.maxOutstanding||5,this._withCredentials=t.crossOriginCredentials||!1,this._timeout=null==t.timeout?i.DEFAULT_TIMEOUT:t.timeout,this._preferFetch=!0===t.preferFetch,this._requestIdPrefix=t.requestIdPrefix,t.server&&(this.server=t.server)}get isActive(){return this._isActive}set isActive(e){this._isActive!==e&&(this._isActive=e,e||this._authProvider.logout(),this._checkQueue())}get crossOriginCredentials(){return this._withCredentials}set crossOriginCredentials(e){this._withCredentials=e}get maxOutstanding(){return this._maxOutstanding}set maxOutstanding(e){this._maxOutstanding=e,this._checkQueue()}get handlesRedirects(){return this._handlesRedirects}get server(){return this._server}set server(e){this._server=e&&e.endsWith("/")?e.substr(0,e.length-1):e}_forceXhr(e,t=!1){this._forcedXhr=e,this._handlesRedirects=!t}_useFetchApi(e){this._fetch=e}setAdditionalHeaders(e){this._additionalHeaders=e||{}}setValidateStatus(e){this._isStatusValid=e}setAdditionalNodeOptions(e){this._additionalNodeOptions=e,r.isNode()&&e&&0===e.maxRedirects&&(this._handlesRedirects=!1)}setRetryOptions(e){this._retryOptions=e}set authenticationAllowList(e){this._authProvider.authenticationAllowList=e}get authenticationAllowList(){return this._authProvider.authenticationAllowList}get authProvider(){return this._authProvider}setApiKey(e){this._authProvider.setApiKey(e)}setTimeout(e){this._timeout=e}setAuthToken(e){e?this._authProvider.setAuthToken(e):this._authProvider.logout()}_onAuthChange(e,t){w("_oAC",e);const s=this._waitingForAuthentication;"unauthenticated"===e?this._waitingForAuthentication=!0:(this._waitingForAuthentication=!1,!1!==s&&this._checkQueue())}resume(){this._waitingForAuthentication=!1,this._authProvider.resume(),this._checkQueue()}setRequestHooks(e,t){this._beforeHook=e,this._afterHook=t}invoke(t="GET",s,i={},o,h={},a){w("invoke",t,s,h);let u=(h=h||{}).autoParseJson||!1,d=h.responseType;if(null!=d&&"void"!==d||(u=null==h.autoParseJson||h.autoParseJson,d=h.responseType="text"),"defaultbuffer"===d&&(d=r.isNode()?h.responseType="buffer":h.responseType="arraybuffer"),"buffer"===d){if("function"!=typeof Buffer)throw new e.DCXError(e.DCXError.INVALID_PARAMS,"No Buffer class")}else if("blob"===d){if("function"!=typeof Blob)throw new e.DCXError(e.DCXError.INVALID_PARAMS,"No Blob class")}else if(d&&"text"!==d&&"json"!==d&&"arraybuffer"!==d&&"stream"!==d)throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Unsupported response type: "+d);!r.endPointOf(s)&&this.server&&(s=`${this.server}/${s.startsWith("/")?s.substr(1,s.length):s}`),w("invoke href",s);const _=r.merge({},i,this._additionalHeaders);w("invoke headers",i),_["x-request-id"]=[this._requestIdPrefix,this._serviceGuid,_["x-request-id"],""+this._reqNum++].filter((e=>e)).join("."),h.additionalNodeOptions=Object.assign({},this._additionalNodeOptions||{},h.additionalNodeOptions||{}),h.isStatusValid=h.isStatusValid||this._isStatusValid,h.retryOptions=Object.assign({},this._retryOptions||{},h.retryOptions||{});let c={method:t,href:s,headers:_,token:void 0,body:o,options:h,progress:h.reuseRequestDesc?.progress,autoParseJson:u},l=h.reuseRequestDesc;l&&l instanceof n.default&&"props"in l&&(l=l.props),l&&((this._requestQueue.exists(l)||l.id&&null!=this._requestsOutstanding.get(l.id))&&w("requestDesc still in use"),c=r.merge(l,c)),c.id=c.id||r.generateUuid(),a&&("maxRedirects"in h.additionalNodeOptions&&(h.additionalNodeOptions.maxRedirects=0),h.retryOptions&&0!==Object.keys(h.retryOptions).length||(h.retryOptions={disableRetry:!0}));const p=this._getRequestPromise(c);return p.getPromise().then(this._checkQueue.bind(this)).catch(this._checkQueue.bind(this)),r.isAnyFunction(a)&&(w("invoke - cb"),p.then((e=>{w("invoke - cb - resolve ",e.statusCode);try{a(void 0,e,e.response)}catch(e){console.error("[dcx:http] error in success callback",e,e.stack)}})).catch((e=>{w("invoke - cb - reject: ",e);try{a(e,e.response)}catch(e){console.error("[dcx:http] error in failure callback",e,e.stack)}}))),this._checkQueue(),p}_makeRequest(e){w("_makeRequest(): ",e.id);const t=e.options||{},s=R(r.pruneUndefined({url:e.href,autoParseJson:e.autoParseJson,descriptor:e,...e,timeout:t.timeout||this._timeout,authProvider:this._authProvider,forceXhr:this._forcedXhr,fetch:this._fetch,responseType:t.responseType,preCallback:this._beforeHook,postCallback:this._afterHook,isStatusValid:t.isStatusValid,additionalNodeOptions:t.additionalNodeOptions,retryOptions:t.retryOptions,isExternalRequest:t.isExternalRequest,preferFetch:this._preferFetch}));return this._requestsOutstanding.addRequest(e.id,s),e.startTime=(new Date).valueOf(),s}_checkQueue(){queueMicrotask(this._checkQueueLoop.bind(this))}_checkQueueLoop(){if(w("_checkQueueLoop()",this._waitingForAuthentication,this.isActive,this._requestsOutstanding.length,"<?",this.maxOutstanding),!this._isActive){w("_cQL inactive");const t=new e.DCXError(e.DCXError.SERVICE_IS_INACTIVE,"Network request in inactive state");this._requestsOutstanding.clear(t),this._requestQueue.clear(t)}let t=!0;for(;t&&!this._waitingForAuthentication&&this._requestsOutstanding.length<this.maxOutstanding&&(t=this._requestQueue.pop(),null!=t);){const e=this._makeRequest(t.descriptor);t.notifySent(e)}w("_cQL done")}_getRequestPromise(t){return w("_getRequestPromise()"),new n.default(((s,i,o)=>{if(!this._isActive)return w("_gRP inactive"),i(new e.DCXError(e.DCXError.SERVICE_IS_INACTIVE,"Network request in inactive state"));o((()=>{w("_gRP cancel 1",t.id),this._requestQueue.remove(t)}));let n=t.noSoonerThen||null;return n&&(n-=r.now(),n=n<0?0:n>A?A:n),delete t.noSoonerThen,this._requestQueue.push(t,n,this._checkQueue.bind(this)).then((r=>(w("_gRP sent",t.id),r.canceled?(w("_gRP reject 1: ",t.id),i(new e.DCXError(e.DCXError.ABORTED,"Request aborted",r.error))):(o((s=>{w("_gRP cancel 2",t.id,s),r.cancel(new e.DCXError(e.DCXError.ABORTED,"Request aborted",s))})),r.getPromise().then((e=>(w("_gRP resolve 1",t.id,e),s(e)))).catch((e=>(w("_gRP reject 2: ",t.id,e),i(e)))))))).catch(i)}),t)}abort(e){e&&e.cancel?e.cancel():this._requestQueue.exists(e)?this._requestQueue.remove(e):this._requestsOutstanding.removeById(e.id)}abortAllWithToken(e){w("abortAllWithToken()"),this._requestsOutstanding.removeAllWithToken(e),this._requestQueue.removeAllWithToken(e)}}const P=v;exports.AdobeNetworkHTTPService=P,exports.AuthProvider=a,exports.HTTPService=v,exports.Xhr=c,exports.XhrErrorCodes=_,exports.createHTTPService=(e,t)=>new v(e,t||{});
//# sourceMappingURL=index.js.map
