import typescript from '@rollup/plugin-typescript';
import { getBaseConfigs } from '../../config/rollup.base.js';
import pkg from './package.json';

const confs = getBaseConfigs('dcxjs-http', pkg, 'index.ts', true);

function applyNodeSettings(conf, dir) {
    // Compile XhrNode separately
    conf.input = ['index.ts', './src/XhrNode.ts'];
    conf.output.file = undefined;
    conf.output.dir = dir;

    for (let i = 0; i < conf.plugins.length; i++) {
        if (conf.plugins[i].name === 'typescript') {
            conf.plugins[i] = typescript({
                sourceMap: true,
                declaration: false,
                declarationMap: false,
                composite: false,
                outDir: undefined,
            });
            break;
        }
    }

    // Mark all node builtins as external to silence rollup
    const ext = conf.external;
    conf.external = (id) => id === 'http' || id === 'https' || id === 'zlib' || (ext && ext(id));
}

const c = confs['node:cjs'];
if (c) {
    applyNodeSettings(c, 'build/node/');
}

const ce = confs['node:esm'];
if (ce) {
    applyNodeSettings(ce, 'build/nodeesm/');
}

export default Object.values(confs);
