import {
    AdobeAuthProvider,
    AdobeDCXError,
    AdobeResponse,
    AdobeResponseType,
    BackoffOptions,
    BodyType,
    HTTPMethod,
    RequestDescriptor,
    XhrOptions,
} from '@dcx/common-types';

export interface ProgressEvent {
    sentOrReceived: number;
    total: number;
}

export interface CancelEvent {
    reason?: AdobeDCXError;
}

export type RequestEventType = 'progress' | 'cancel';

export interface RequestEvents {
    progress: ProgressEvent;
    cancel: CancelEvent;
}

export type RequestEventHandler<K extends RequestEventType> = (data: RequestEvents[K]) => void;

export interface RequestOptions<T extends AdobeResponseType = AdobeResponseType> extends XhrOptions<T> {
    id: string;
    descriptor: RequestDescriptor;
    method: HTTPMethod;
    authProvider: AdobeAuthProvider;
    url: string;
    headers?: Record<string, string | string[]>;
    body?: BodyType;
    responseType?: T;
    templateParams?: Record<string, string>;
    isStatusValid?: (status?: number, response?: AdobeResponse<any>) => boolean | AdobeDCXError;
    retryOptions?: BackoffOptions<T>;
    isExternalRequest?: boolean;
}
