/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc..
 **************************************************************************/

import { AdobeDCXError, AdobeRequest } from '@dcx/common-types';
import { newDebug } from '@dcx/logger';

const dbg = newDebug('dcx:http:map');

type GenericAdobeRequest = AdobeRequest<any>;

export interface AdobeRequestMap {
    addRequest(id: string, req: GenericAdobeRequest): string;
    get(id: string): GenericAdobeRequest | undefined;
    removeById(id: string): void;
    remove(req: GenericAdobeRequest): void;
    clear(): void;
    has(id: string): boolean;
}

export class RequestMap implements AdobeRequestMap {
    private _map: Map<string, GenericAdobeRequest> = new Map();
    // private _count = 0;

    addRequest(id: string, req: GenericAdobeRequest) {
        // const id = this._count++;
        dbg('addRequest()', id);
        this._map.set(id, req);

        req.getPromise()
            .then((res) => {
                dbg('then', id);
                this._map.delete(id);
            })
            .catch((e) => {
                dbg('catch', id, e);
                this._map.delete(id);
            });

        return id;
    }

    get(id: string): GenericAdobeRequest | undefined {
        return this._map.get(id);
    }

    get length(): number {
        return this._map.size;
    }

    public has(id: string): boolean {
        return this._map.has(id);
    }

    removeById(id: string) {
        const req = this._map.get(id);
        if (req) {
            this.remove(req);
        }
    }

    remove(req: GenericAdobeRequest, err?: AdobeDCXError) {
        return req && req.cancel && req.cancel(err);
    }

    clear(err?: AdobeDCXError) {
        this._map.forEach((req) => {
            this.remove(req, err);
        });
        this._map.clear();
    }

    removeAllWithToken(token: unknown) {
        this._map.forEach((req) => {
            if (req.descriptor.token === token) {
                this.remove(req);
            }
        });
    }
}
