/**
 * Get the fetch from teh global context and bind it to said context
 * @internal
 */
export function _getGlobalFetch() {
    if (typeof window !== 'undefined' && 'fetch' in window && typeof window.fetch === 'function') {
        return window.fetch.bind(window);
    }
    if (typeof self !== 'undefined' && 'fetch' in self && typeof self.fetch === 'function') {
        return self.fetch.bind(self);
    }
    if (typeof global !== 'undefined' && 'fetch' in global && typeof global.fetch === 'function') {
        return global.fetch.bind(global);
    }
}
