/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeAuthProvider, AdobeHTTPService, AdobeHTTPServiceOptions, AdobeResponseType, AuthenticationCallback, InvokeOptions } from '@dcx/common-types';
export { AdobeHTTPService, AdobeHTTPServiceOptions, AdobeResponse, AdobeResponseType, AuthenticationCallback, RequestDescriptor, ResponseCallback, } from '@dcx/common-types';
export * from './src/AuthProvider';
export * from './src/HTTPService';
export * from './src/Xhr';
/**
 * Type alias to {@link InvokeOptions}
 */
export type RequestOptions<T extends AdobeResponseType = AdobeResponseType> = InvokeOptions<T>;
/**
 * The {@link AdobeNetworkHTTPService} class. Gives access to the DCX network service.
 * @readonly
 * @type {AdobeNetworkHTTPService}
 */
export declare const AdobeNetworkHTTPService: {
    new (authHandler?: AuthenticationCallback | AdobeAuthProvider, options?: AdobeHTTPServiceOptions): AdobeHTTPService;
};
/**
 * Constructs and returns a network service instance.
 * @public
 * @example
 * ```js
 * // using AuthProvider
 * const refreshCb = async (service, provider) => {
 *   const t = await getToken();
 *   service.setAuthToken(t);
 * }
 * const ap = new AuthProvider('token', 'apikey', refreshCb);
 * const service = createHTTPService(ap);
 * service.setAdditionalHeaders( {'foo': 'bar'} );
 * ```
 *
 * @example
 * ```js
 * // using callback
 * const service = createHTTPService((service) => {
 *      myGetToken((token) => {
 *          service.setAuthToken(token);
 *      });
 * });
 * service.setApiKey('MyApiKey');
 * service.setAdditionalHeaders( {'foo': 'bar'} );
 * ```
 *
 * @param  {AuthenticationCallback | AdobeAuthProvider} [authHandler]
 *                                          - Either a function or AuthProvider instance.
 *                                            Called when the HTTPService receives a 401 status code.
 *                                            The callback should handle setting a new auth token, which
 *                                            then resumes the service, or explicitly call `resume()`.
 *                                            If not provided, will ignore authentication.
 * @param { AdobeHTTPServiceOptions }   [options] - Configuration options
 */
export declare const createHTTPService: (authHandler?: AuthenticationCallback | AdobeAuthProvider, options?: AdobeHTTPServiceOptions) => AdobeHTTPService;
//# sourceMappingURL=index.d.ts.map