/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeAuthProvider, AuthChangeHandler, AuthData, DetachHandler, PersistentRefreshCallback } from '@dcx/common-types';
export declare class AuthProvider implements AdobeAuthProvider {
    private _authToken?;
    private _apiKey?;
    private _pendingAuth;
    private _hasBaseRefreshCb;
    private _authListeners;
    private _persistentListeners;
    private _refreshResolve?;
    private _refreshPromise?;
    private _authenticationAllowList;
    private _authTokenScheme;
    constructor(_authToken?: string | undefined, _apiKey?: string | undefined, persistentRefreshCb?: PersistentRefreshCallback);
    /**
     * Used for redirects.
     *
     * Sets a list of hostnames that forwarding auth token & API key is allowed.
     *
     * By default, will strip auth token from any non-https host
     * as well as any host that is not identical to the initial hostname.
     */
    get authenticationAllowList(): string[];
    set authenticationAllowList(val: string[]);
    /**
     * Returns true when the AuthProvider is initialized without any persistent refresh callback
     * Assumes there's no way for the authentication to come from later handlers.
     * If this isn't the case, clients can set this manually after registering their
     * handler that will provide refreshing.
     */
    get isNoAuthMode(): boolean;
    set isNoAuthMode(val: boolean);
    get apiKey(): string | undefined;
    get authToken(): string | undefined;
    get authTokenScheme(): string | undefined;
    set authTokenScheme(val: string | undefined);
    /**
     * Sets a new auth token and emits the {@link AuthEvent} `updated`.
     *
     * @param {string} authToken
     */
    setAuthToken(authToken: string | undefined): void;
    /**
     * Set API Key.
     *
     * @param {string} apiKey - apiKey to set
     */
    setApiKey(apiKey: string): void;
    /**
     * Explicitly mark provider as no longer pending authentication.
     * Can be used instead of Promise returns.
     */
    resume(): void;
    /**
     * Get pending state.
     * Returns true when the provider is waiting for authentication to complete.
     */
    get pendingAuth(): boolean;
    /**
     * Register a change handler.
     * Possible event types: {@link AuthEvent}
     * Handlers may return promises, but unlike the refreshAuthCallback
     * constructor parameter, the promises are assumed to return void
     * and resolution values are awaited, but not used.
     * @param {AuthChangeHandler} handler
     * @returns {DetachHandler}
     */
    onChange(handler: AuthChangeHandler, persistent?: boolean): DetachHandler;
    /**
     * Remove all non-persistent listeners.
     * If passed `true`, will clear persistent listeners, too.
     *
     * @param {boolean} [clearPersistent = false] - Clear persistent listeners.
     */
    clearListeners(clearPersistent?: boolean): void;
    /**
     * @internal
     */
    get refreshPromise(): Promise<AuthData> | undefined;
    /**
     * First set pending state according to the event.
     * Then call auth change listeners.
     *
     * If a listener returns a promise, collect it and resolve all promises together.
     *
     * If the event is `updated`, resolve any waiting promise AFTER the listeners.
     * This means that the refreshAuth promise will resolve AFTER all registered
     * listeners, which is good since HTTPService will reactivate itself in a listener.
     *
     * @param {AuthEvent} event
     */
    private _authChanged;
    private _resolveRefresh;
    /**
     * Emit the {@link AuthEvent} `unauthenticated` event,
     * wait for all handlers to complete,
     * then return the auth data.
     *
     * @returns {Promise<AuthData>}
     */
    refreshAuth(): Promise<AuthData>;
    /**
     * Get current authentication data as object.
     *
     * @returns {AuthData}
     */
    getAuthData(): AuthData;
    /**
     * Get current auth data as a promise.
     */
    getAuth(): Promise<AuthData>;
    /**
     * Check if URL has domain that belongs to allow list.
     * @param url
     */
    isAuthorizedURL(url: string): boolean;
    /**
     * Clear auth data, reset to pending authentication.
     */
    logout(): void;
    /**
     * Applies Authorization and X-Api-Key headers if the url is part of the allowed
     * @param headers
     */
    applyAuthHeaders(url: string, headers: Record<string, string>): Record<string, string>;
}
//# sourceMappingURL=AuthProvider.d.ts.map