/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdditionalNodeOptions, AdobeAuthProvider, AdobeDCXError, AdobeHTTPService, AdobeHTTPServiceOptions, AdobeResponse, AdobeResponseType, AuthenticationCallback, BackoffOptions, BodyType, HTTPMethod, InvokeOptions, PostRequestHook, PreRequestHook, RequestDescriptor } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { SinonFakeXMLHttpRequestStatic } from 'sinon';
/**
 * @class
 * @classdesc A network service instance.
 * <p>The constructor for `AdobeNetworkHTTPService` is private. Refer to {@link AdobeDCX} to learn how
 * to create instances of `AdobeNetworkHTTPService`.
 * @param {AuthenticationCallback | AuthProvider} [authHandler] Called when authentication fails. This callback is only called
 * once per expired/invalid token/cookie. The service will queue up any further requests. <p>The client must obtain and set a new
 * authentication token or cookie and then call resume()</p> <p>If not provided then the service will not try to manage
 * authentication.</p> <p>Signature: authCallback(httpService)</p>
 */
export declare class HTTPService implements AdobeHTTPService {
    readonly name = "AdobeHTTPService";
    private _requestQueue;
    private _requestsOutstanding;
    private _authProvider;
    private _isActive;
    private _waitingForAuthentication;
    private _forcedXhr?;
    private _preferFetch;
    private _fetch?;
    private _handlesRedirects;
    private _maxOutstanding;
    private _server?;
    private _withCredentials;
    private _timeout;
    private _additionalHeaders?;
    private _additionalNodeOptions;
    private _retryOptions;
    private _beforeHook?;
    private _afterHook?;
    private _isStatusValid?;
    private _requestIdPrefix?;
    private _serviceGuid;
    private _reqNum;
    featureFlags: any;
    /**
     * @param {AuthProvider | AuthenticationCallback} authHandler - AuthProvider or callback.
     *      When using a callback, use {@link AdobeHTTPServiceOptions} `useAuthProvider` option set
     *      to true to receive the auth provider instead of the service.
     */
    constructor(authHandler?: AuthenticationCallback | AdobeAuthProvider, options?: AdobeHTTPServiceOptions);
    /**
     * An inactive service will error out with a AdobeDCXError.SERVICE_IS_INACTIVE error
     * whenever a request is being made. Clients can set isActive to false when the user
     * has explicitly logged out.
     * @memberof AdobeNetworkHTTPService#
     * @default true
     * @type {Boolean}
     */
    get isActive(): boolean;
    set isActive(value: boolean);
    /**
     * If true then XHR instances will have the withCredentials property set which means that user
     * credentials (stored in a cookie) will be used in cross origin requests.
     * @memberof AdobeNetworkHTTPService#
     * @type {Boolean}
     */
    get crossOriginCredentials(): boolean;
    set crossOriginCredentials(value: boolean);
    /**
     * The maximum number of outstanding requests over this HTTP Service instance.
     * The default value is 5, to stay below browser connection limits, but the limit
     * can be increased if you have special circumstances that warrant it.
     * Remember that there is no use in exceeding the bandwith capacity of your client
     * or of the host, and that in error cases it's better to have half of your
     * uploads complete than all of your uploads half complete.
     * @memberof AdobeNetworkHTTPService#
     */
    get maxOutstanding(): number;
    set maxOutstanding(value: number);
    /**
     * Whether the platform handles redirects natively.
     * Returns true for browser and false for Node,
     * although Node builds may also be configured to handle redirects.
     */
    get handlesRedirects(): boolean;
    get server(): string | undefined;
    set server(val: string | undefined);
    /** force use of xhr (generally for testing)
     * @internal
     */
    _forceXhr(xhr: SinonFakeXMLHttpRequestStatic | undefined, xhrDoesNotHandleRedirects?: boolean): void;
    /** force use of a specific fetch API (generally for testing)
     * @internal
     */
    _useFetchApi(fetchApi: typeof fetch): void;
    /**
     * Sets additional headers.
     * @param {Object} additionalHeaders An object containing key-value pairs for each additional header to supply.
     */
    setAdditionalHeaders(additionalHeaders: Record<string, string>): void;
    /**
     * Sets a function that denotes whether a Promise should resolve or reject given a status
     * By default, this is function that always returns true meaning any status code will resolve.
     * @param {(status?: number, response?: AdobeResponse) => boolean} fn
     */
    setValidateStatus(fn: (status?: number, xhr?: AdobeResponse) => boolean): void;
    /**
     * Sets additional options.
     * @param {Object} additionalOptions An object containing additional options to
     *                                   supply with each http request (in Node only).
     */
    setAdditionalNodeOptions(aOpts: AdditionalNodeOptions): void;
    /**
     * Set options for retrying failed requests
     * @param {BackoffOptions<any>} retryOptions
     */
    setRetryOptions(retryOptions: BackoffOptions<never>): void;
    /**
     * Used for redirects.
     *
     * Sets a list of hostnames that forwarding auth token & API key is allowed.
     *
     * By default, will strip auth token from any non-https host
     * as well as any host that is not identical to the initial hostname.
     */
    set authenticationAllowList(value: string[]);
    get authenticationAllowList(): string[];
    get authProvider(): AdobeAuthProvider;
    /**
     * Sets the API key.
     * @param {String} apiKey The apikey to supply with each request.
     */
    setApiKey(apiKey: string): void;
    /**
     * Sets the timeout value for requests.
     * This is the per-request timeout, not related to backoff timeouts.
     * To set the backoff timeout, provide a value in the `retryOptions`
     * property of the invoke options.
     * @param {Integer} timeout timeout value in ms or undefined if no timeout
     */
    setTimeout(timeout: number): void;
    /**
     * Sets the authentication token and resumes the service.
     * @param {String} token The authentication token, if not provided, logs out
     */
    setAuthToken(token?: string): void;
    private _onAuthChange;
    /**
     * Call this when you do not use an auth token for authentication and you need to let the
     * service know that you have renewed the authentication cookie so that the service can
     * resume to make requests.
     */
    resume(): void;
    /**
     * Sets callbacks before and after invocation hook.
     * (For testing)
     * @private
     * @param before a hook to call before each http request is issued. Signature: before(req).
     * @param after  a hook to be called after each http request is initiated: Signature: after(req, xhr).
     */
    setRequestHooks(before?: PreRequestHook, after?: PostRequestHook): void;
    invoke<T extends AdobeResponseType>(method: HTTPMethod, href: string, headers?: Record<string, string>, body?: BodyType, options?: InvokeOptions<T>): AdobePromise<AdobeResponse<T>, AdobeDCXError, RequestDescriptor>;
    /**
     * Create Request and add to the outstandingRequest map.
     * @param requestDesc
     */
    private _makeRequest;
    /**
     * Initiate _checkQueueLoop asynchronously
     */
    private _checkQueue;
    /**
     * Iterate through queue until one of:
     * 1. maxOutstanding is reached
     * 2. authentication expires
     * 3. queue is empty
     *
     * Make the request, then notify queuer that the request has been sent.
     */
    private _checkQueueLoop;
    /**
     * Get the request Promise.
     * The request is always queued, which returns a promise that resolves when the request is
     * sent and added to the outstandingRequest map.
     * @param {RequestDescriptor} requestDesc - request descriptor
     * @returns {AdobePromise<[AdobeResponse<T>, T], AdobeDCXError, RequestDescriptor>}
     */
    private _getRequestPromise;
    /** @private */
    private abort;
    /** @internal */
    abortAllWithToken(token: unknown): void;
}
export default HTTPService;
//# sourceMappingURL=HTTPService.d.ts.map