/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc..
 **************************************************************************/
import { AdobeDCXError, AdobeResponseType, AdobeXhr, BackoffSnapshot, BodyType, HTTPMethod } from '@dcx/common-types';
import { RequestEventType, RequestEvents, RequestOptions } from './RequestEvents';
import { backoff } from './backoff';
/**
 * Base network request events
 * All requests have these hooks
 */
export type NetworkRequestEvents = 'success' | 'error' | 'cancel' | 'progress';
export declare const NetworkRequestEvents: {
    success: string;
    error: string;
    cancel: string;
    progress: string;
};
/**
 * Non-pausable network request
 * GET, HEAD, OPTIONS
 * and PUT, POST when body size < min chunk size
 */
export interface AdobeNetworkRequest<T extends AdobeResponseType> {
    getPromise(): Promise<AdobeXhr<T>>;
    cancel(err?: AdobeDCXError): void;
    getSnapshot(): BackoffSnapshot<T>;
    onProgress(handler: any): ReturnType<typeof backoff>['onProgress'];
}
export declare class NetworkRequest<T extends AdobeResponseType> implements AdobeNetworkRequest<T> {
    private _promise;
    private _cancel;
    private _getSnapshot;
    onProgress: any;
    constructor(url: string, method: HTTPMethod, body: BodyType | undefined, headers: Record<string, string>, responseType?: AdobeResponseType, notify?: <K extends RequestEventType>(event: K, data: RequestEvents[K]) => void, authCallback?: (url: string, headers: Record<string, string>) => Promise<Record<string, string>>, options?: Partial<RequestOptions<T>>);
    getSnapshot(): BackoffSnapshot<T>;
    getPromise(): Promise<AdobeXhr<T>>;
    cancel(err?: AdobeDCXError): void;
}
//# sourceMappingURL=NetworkRequest.d.ts.map