/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc..
 **************************************************************************/
import { AdobeDCXError, AdobeRequest, AdobeResponse, AdobeResponseType, RequestDescriptor } from '@dcx/common-types';
import { RequestEventHandler, RequestEventType, RequestOptions } from './RequestEvents';
/**
 * Handles creating the request or job
 *
 * @note
 * Jobs are currently not used, UploadJob logic is instead being implemented as BlockUpload in the assets module.
 *
 */
export declare class Request<T extends AdobeResponseType = any> implements AdobeRequest<T> {
    private static _internalOnlyHeaders;
    private _id;
    private _networkRequest;
    private _pausable;
    private _promise;
    private _isStatusValid;
    private _listeners;
    private _isExternalRequest;
    private _authProvider;
    private _descriptor;
    constructor(opts: RequestOptions<T>);
    get id(): string;
    get descriptor(): RequestDescriptor;
    private _getAuthCb;
    private _authCb;
    private _emit;
    getPromise(): Promise<AdobeResponse<T>>;
    cancel(err?: AdobeDCXError): void;
    on<K extends RequestEventType>(event: K, handler: RequestEventHandler<K>): void;
}
export declare const AdobeRequestMaker: {
    makeRequest: <T extends keyof import("@dcx/common-types").ResponseTypeMap = keyof import("@dcx/common-types").ResponseTypeMap>(opts: RequestOptions<T>) => AdobeRequest<T>;
};
//# sourceMappingURL=Request.d.ts.map