/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc..
 **************************************************************************/
import { AdobeDCXError, AdobeRequest } from '@dcx/common-types';
type GenericAdobeRequest = AdobeRequest<any>;
export interface AdobeRequestMap {
    addRequest(id: string, req: GenericAdobeRequest): string;
    get(id: string): GenericAdobeRequest | undefined;
    removeById(id: string): void;
    remove(req: GenericAdobeRequest): void;
    clear(): void;
    has(id: string): boolean;
}
export declare class RequestMap implements AdobeRequestMap {
    private _map;
    addRequest(id: string, req: GenericAdobeRequest): string;
    get(id: string): GenericAdobeRequest | undefined;
    get length(): number;
    has(id: string): boolean;
    removeById(id: string): void;
    remove(req: GenericAdobeRequest, err?: AdobeDCXError): void;
    clear(err?: AdobeDCXError): void;
    removeAllWithToken(token: unknown): void;
}
export {};
//# sourceMappingURL=RequestMap.d.ts.map