/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc..
 **************************************************************************/
import { AdobeDCXError, AdobeRequest, AdobeResponseType, RequestDescriptor } from '@dcx/common-types';
export type NotifySentFn<T = AdobeRequest<any>> = (req: T) => void;
export type NotifyCancelFn = (err?: AdobeDCXError) => void;
export declare const RD_INDEX = 0;
export declare const SENT_INDEX = 1;
export declare const REJ_INDEX = 2;
export interface QueuedRequest<T = AdobeRequest<any>> {
    descriptor: RequestDescriptor;
    notifySent: NotifySentFn<T>;
    wait?: number;
}
interface CanceledRequest {
    canceled?: true;
    error?: AdobeDCXError;
}
/**
 * RequestQueue
 * Queues requests in preferential order for HEAD requests.
 *
 * Head end pointer points to the first index that is not a HEAD request, for example:
 * [HEAD][HEAD][HEAD][HEAD][POST][GET][PUT]
 * _headEndPtr = 4
 */
export declare class RequestQueue {
    private _queue;
    private _later;
    private _headEndPtr;
    private _isPriority;
    private _usePriority;
    /**
     * Add request to queue.
     * Returns promise that resolves when:
     * 1. The request is sent and the sender calls QueuedRequest.notifySent with the sent request
     * 2. The request is removed from the queue before sending, in which case `canceled` will be `true`
     *
     * @param request
     */
    push<K extends AdobeResponseType = any>(request: RequestDescriptor, wait?: number | null, onReady?: (req?: QueuedRequest<AdobeRequest<K>>) => void): Promise<AdobeRequest<K> & CanceledRequest>;
    private _notifyCanceled;
    private _push;
    remove(req: RequestDescriptor): void;
    private _remove;
    /**
     * Returns the index of a queued request.
     * Does not take into account the later-queued requests.
     * @param req
     */
    private _indexOf;
    exists(req: RequestDescriptor): boolean;
    /**
     * Move request from later to queue
     * @param reqId
     */
    private _ready;
    pop<K extends AdobeResponseType = any>(): QueuedRequest<AdobeRequest<K>> | undefined;
    get length(): number;
    clear(err?: AdobeDCXError): void;
    removeAllWithToken(token: unknown): void;
}
export {};
//# sourceMappingURL=RequestQueue.d.ts.map