/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc..
 **************************************************************************/
import { AdobeResponseType, AdobeXhr, AdobeXhrNode, BodyType, HTTPMethod, ProgressListener, ResponseTypeMap, XhrOptions, XhrResponse } from '@dcx/common-types';
export declare const XhrErrorCodes: {
    NO_ERROR: string;
    ABORTED: "ABORTED";
    NETWORK: "NETWORK_ERROR";
    TIMEOUT: "TIMED_OUT";
    TOO_MANY_REDIRECTS: "TOO_MANY_REDIRECTS";
    INSECURE_REDIRECT: "INSECURE_REDIRECT";
};
export declare class Xhr<T extends AdobeResponseType> implements AdobeXhr<T> {
    private _autoParsedResponse;
    private _autoParseJson;
    private _bytesReported;
    private _errorCode;
    private _estimatedTotalBytes?;
    private _isFetchRequest;
    private _fetch?;
    private _fetchAbort;
    private _fetchResponse?;
    private _parsedResponseHeaders?;
    private _fetchBodyAsResponseType?;
    private _postCallback?;
    private _preCallback?;
    private _preferFetch;
    private _promise;
    private _resolve;
    private _response?;
    private _sent;
    private _timeout;
    private _timeoutTimeout;
    private _underlyingError?;
    private _xhr;
    href: string;
    method: HTTPMethod;
    headers: Record<string, string | string[]>;
    body?: BodyType;
    responseType: AdobeResponseType;
    private _progressListeners;
    constructor(opts?: XhrOptions<T>);
    get xhr(): XMLHttpRequest | AdobeXhrNode;
    private _parseFetchResponse;
    private _shouldAutoParseResponse;
    private _fetchWithTimeout;
    private _finalize;
    private _validateResponseType;
    send(url: string, method: HTTPMethod, body?: BodyType, headers?: Record<string, string | string[]>, responseType?: T, options?: XhrOptions<T>): Promise<AdobeXhr<T>>;
    abort(): void;
    getResponseHeader(header: string): string | undefined;
    getAllResponseHeaders(): Record<string, string>;
    isError(): boolean;
    isAborted(): boolean;
    isTimedOut(): boolean;
    isSent(): boolean;
    getErrorCode(): number | string;
    getStatus(): number;
    getResponse(): XhrResponse<T>;
    toJSON(): {
        statusCode: number;
        headers: Record<string, string>;
        responseType: T;
        response: ResponseTypeMap[T];
        message: string;
    };
    getResponseDataAsJSON(): Promise<any>;
    getResponseData(): ResponseTypeMap[T];
    onProgress(handler: ProgressListener): () => void;
    private _notifyProgressListeners;
}
//# sourceMappingURL=Xhr.d.ts.map