/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc..
 **************************************************************************/
/// <reference types="node" />
import { AdditionalNodeOptions, AdobeResponseType } from '@dcx/common-types';
type XhrInternalEvents = 'progress' | 'load' | 'error' | 'abort';
interface XhrNodeInternal {
    addEventListener<T extends XhrInternalEvents>(type: T, listener: (this: XMLHttpRequest, ev: ProgressEvent<XMLHttpRequestEventTarget>) => never, options?: boolean | AddEventListenerOptions): void;
}
export declare class XhrNode implements XhrNodeInternal {
    private _promise;
    private _method;
    private _url;
    private _requestHeaders;
    private _responseHeaders;
    private _listeners;
    private _response;
    private _status?;
    private _statusText?;
    private _bytesReported;
    private _totalBytes;
    private _authenticationAllowList;
    private _additionalOptions;
    private _parsedUrl?;
    private _cancelToken;
    readyState?: number;
    get response(): any;
    get status(): number | undefined;
    get statusText(): string | undefined;
    private _responseText?;
    get responseText(): string;
    set responseText(val: string);
    responseEncoding?: BufferEncoding;
    responseType?: AdobeResponseType;
    responseURL?: string;
    responseXML?: Document;
    timeout?: number;
    upload?: XMLHttpRequestUpload;
    withCredentials?: boolean;
    maxRedirects?: number;
    constructor();
    get requestHeaders(): Record<string, string | number | string[] | undefined>;
    setNodeOptions(opts?: AdditionalNodeOptions): void;
    abort(): void;
    getAllResponseHeaders(): Record<string, string | string[]>;
    getResponseHeader(name: string): string | string[] | undefined;
    private _isHostnameOnAllowList;
    open(method: string, url: string, async?: boolean): void;
    send(body?: string | Document | Blob | ArrayBufferView | ArrayBuffer | FormData | URLSearchParams | ReadableStream<Uint8Array>): void;
    /**
     * Transform the data collected into the expected responseType,
     * then resolve the promise.
     *
     * If the requested responseType is `stream`, this function is skipped entirely.
     *
     * If `json` is requested, and parsing fails, return the data as a string.
     *
     * @param resolve
     * @param reject
     * @param config
     * @param res
     */
    private _settleResponse;
    /**
     * Ensure tokens are not sent over http.
     * Reject the promise if that would happen.
     *
     * @param {Function} reject
     * @param {*} options
     * @param {Record<string, string>} headers
     */
    private _secureAuth;
    /**
     * Perform https request.
     * Use follow-redirects if maxRedirects is specified.
     * Returns promise that resolves when request ends,
     * or rejects on network errors.
     *
     * @param httpsOpts
     * @param config
     */
    private _sendRequest;
    private _reportProgress;
    setRequestHeader(name: string, value: string): void;
    addEventListener<K extends 'readystatechange' | 'abort' | 'error' | 'load' | 'loadend' | 'loadstart' | 'progress' | 'timeout'>(type: K, listener: (ev: XMLHttpRequestEventMap[K]) => any): void;
    private _notifyListeners;
}
export {};
//# sourceMappingURL=XhrNode.d.ts.map