/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc..
 **************************************************************************/
import { AdobeResponseType, Backoff, BackoffOptions, BodyType, HTTPMethod } from '@dcx/common-types';
/**
 * Call a handle function after some timeout
 * On failure, retry after a wait time
 * Increase the wait time by some function
 *
 * Options: {@link BackoffOptions}
 *
 * @param {string} url
 * @param {HTTPMethod} method
 * @param {BodyType} body
 * @param {Record<string, string>} headers
 * @param {BackoffOptions} options
 *
 * @returns {Backoff}
 */
export declare function backoff<T extends AdobeResponseType>(url: string, method: HTTPMethod, body?: BodyType, headers?: Record<string, string>, perRequestTimeout?: number, options?: BackoffOptions<T>, isPolling?: boolean): Backoff<T>;
//# sourceMappingURL=backoff.d.ts.map