/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeDCXLogger, LogCallback, StringLike } from './src/AdobeDCXLogger';
export { AdobeDCXLogger, DebugFormatter, LogCallback, LogLevel, StringLike } from './src/AdobeDCXLogger';
export { AnalyticsComponentEvent, AnalyticsCompositeEvent, AnalyticsEvent, AnalyticsEventCategory, AnalyticsEventSubCategory, AnalyticsEventType, makeAnalyticsEvent, } from './src/analytics';
export declare const getGlobalOrLocalLogger: () => AdobeDCXLogger;
export declare const emitAnalyticsEvent: <T extends [type: (import("./src/analytics").AnalyticsEvent.PushComposite | import("./src/analytics").AnalyticsEvent.CreateComposite | import("./src/analytics").AnalyticsEvent.PullComposite | import("./src/analytics").AnalyticsEvent.PullCompositeVersion) | (import("./src/analytics").AnalyticsEvent.UploadComponent | import("./src/analytics").AnalyticsEvent.DownloadComponent), data: {
    composite: import("@dcx/common-types").AdobeDCXComposite;
    branch?: import("@dcx/common-types").AdobeDCXBranch | undefined;
    response: import("@dcx/common-types").AdobeResponse<any>;
    error?: import("@dcx/common-types").AdobeDCXError<unknown> | undefined;
    component?: {
        relationship?: string | undefined;
        type?: string | undefined;
        length?: number | undefined;
    } | undefined;
    derivationType?: number | undefined;
    isBlockTransferred?: boolean | undefined;
}, service?: string | undefined]>(key: T[0], data: T[1]) => void;
export declare const getGlobalLogger: () => AdobeDCXLogger;
/**
 * Sets the logCallback function
 * Backward compatible, intercepts logs at or above specified log level
 *
 * @param {LogCallback} logCallback called when DCX wants to log something to the client.
 */
export declare const setLogCallback: (logCallback?: LogCallback) => void;
/**
 * Log any number of messages
 *
 * @param {(string | StringLike)[]} messages - set of messages to log
 */
export declare const log: (...messages: (string | StringLike)[]) => void;
/**
 * Get Debug instance
 *
 * @param {string} name - namespace of debugger
 */
export declare const newDebug: (namespace: string) => (...args: any[]) => void;
declare const _default: AdobeDCXLogger;
export default _default;
//# sourceMappingURL=index.d.ts.map