/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeDCXBranch, AdobeDCXComposite, AdobeDCXError, AdobeResponse } from '@dcx/common-types';
export declare const VERSION: string;
export declare const COM_NAME = "dcx-js";
export declare const SVC_NAME = "css";
export declare enum AnalyticsEventType {
    Success = 0,
    Error = 1
}
export declare enum AnalyticsEventCategory {
    CompositeXfer = 0
}
export declare enum AnalyticsEventSubCategory {
    Push = 0,
    MinPull = 1,
    VersionPull = 2,
    Upload = 3,
    Download = 4,
    Create = 5,
    Unknown = 6
}
interface AnalyticsEventBase {
    /**
     * Library name
     * See {@link https://git.corp.adobe.com/DMA/dcx-js/pull/575#discussion_r3873327}
     * and {@link https://git.corp.adobe.com/DMA/dcx-js/pull/575#discussion_r3876987}
     */
    'env.com.name': 'dcx-js';
    /**
     * API type (cc-storage, css, ..)
     * See {@link https://git.corp.adobe.com/DMA/dcx-js/pull/575#discussion_r3876987}
     */
    'env.svc.name': string;
    /**
     * dcx-js version
     */
    'env.com.version': string;
    /**
     * x-request-id from the request
     * This may be the last request or the failed request
     * See {@link https://git.corp.adobe.com/DMA/dcx-js/pull/575#discussion_r3875392}
     */
    'event.request_id': string;
    /**
     * Cloud asset ID
     */
    'event.cloud_id': string;
    /**
     * Cloud repository ID
     */
    'custom.content.repository_id': string;
    /**
     * Type
     * (success or failure)
     */
    'event.type': AnalyticsEventType;
    /**
     * Not set
     * See {@link https://git.corp.adobe.com/DMA/dcx-js/pull/575#discussion_r3873385}
     * and {@link https://git.corp.adobe.com/DMA/dcx-js/pull/575#discussion_r3876968}
     */
    /**
     * Category
     * (only CompositeXfer)
     */
    'event.category': AnalyticsEventCategory;
    /**
     * Subcategory
     * (push, pull, etc.)
     */
    'event.subcategory': AnalyticsEventSubCategory;
}
interface AnalyticsErrorEvent {
    'event.error_code': string;
    'event.error_desc': string;
    'dcx.underlying_error_code'?: string;
    'dcx.underlying_error_desc'?: string;
}
/**
 * ========================================
 * ========= Composite Events =============
 * ========================================
 */
interface AnalyticsCompositeSuccessEvent extends AnalyticsEventBase {
    'dcx.num_total_components': number;
    'custom.content.xmp_derivation_type': number;
}
interface AnalyticsCompositeFailureEvent extends AnalyticsCompositeSuccessEvent, AnalyticsErrorEvent {
    'dcx.root_error_desc': string;
}
export type AnalyticsCompositeEvent = Partial<AnalyticsCompositeSuccessEvent> | Partial<AnalyticsCompositeFailureEvent>;
/**
 * ========================================
 * ========= Component Events =============
 * ========================================
 */
interface AnalyticsComponentSuccessEvent extends AnalyticsEventBase {
    'content.mimetype': string;
}
interface AnalyticsComponentFailureEvent extends AnalyticsComponentSuccessEvent, AnalyticsErrorEvent {
    'dcx.block_transferred': boolean;
    'content.type': string;
    'content.size': number;
    'dcx.component_rel'?: string;
}
export type AnalyticsComponentEvent = Partial<AnalyticsComponentSuccessEvent> | Partial<AnalyticsComponentFailureEvent>;
/**
 * Emitted event types valid for registration.
 */
export declare enum AnalyticsEvent {
    PushComposite = "analyticsPush",
    CreateComposite = "analyticsCreate",
    PullComposite = "analyticsPull",
    PullCompositeVersion = "analyticsPullVersion",
    UploadComponent = "analyticsUpload",
    DownloadComponent = "analyticsDownload",
    All = "*"
}
type CompositeAnalyticsKeys = Exclude<AnalyticsEvent, AnalyticsEvent.All | AnalyticsEvent.DownloadComponent | AnalyticsEvent.UploadComponent>;
type ComponentAnalyticsKeys = Exclude<AnalyticsEvent, AnalyticsEvent.All | AnalyticsEvent.CreateComposite | AnalyticsEvent.PullComposite | AnalyticsEvent.PullCompositeVersion | AnalyticsEvent.PushComposite>;
export type AnalyticsEventHandlers = {
    [AnalyticsEvent.PushComposite]: (event: AnalyticsCompositeEvent) => void;
    [AnalyticsEvent.CreateComposite]: (event: AnalyticsCompositeEvent) => void;
    [AnalyticsEvent.PullComposite]: (event: AnalyticsCompositeEvent) => void;
    [AnalyticsEvent.PullCompositeVersion]: (event: AnalyticsCompositeEvent) => void;
    [AnalyticsEvent.UploadComponent]: (event: AnalyticsComponentEvent) => void;
    [AnalyticsEvent.DownloadComponent]: (event: AnalyticsComponentEvent) => void;
};
/**
 * Make an analytics event.
 * @param type
 * @param data
 * @param service
 */
export declare function makeAnalyticsEvent(type: ComponentAnalyticsKeys, data: {
    composite: AdobeDCXComposite;
    response: AdobeResponse;
    error?: AdobeDCXError | undefined;
    component: {
        relationship?: string;
        type?: string;
        length?: number;
    };
    isBlockTransferred?: boolean;
}, service?: string): AnalyticsComponentEvent;
export declare function makeAnalyticsEvent(type: CompositeAnalyticsKeys, data: {
    composite: AdobeDCXComposite;
    branch: AdobeDCXBranch;
    response: AdobeResponse;
    error?: AdobeDCXError;
    derivationType: number;
}, service?: string): AnalyticsCompositeEvent;
export declare function makeAnalyticsEvent(type: CompositeAnalyticsKeys | ComponentAnalyticsKeys, data: {
    composite: AdobeDCXComposite;
    branch?: AdobeDCXBranch;
    response: AdobeResponse;
    error?: AdobeDCXError | undefined;
    component?: {
        relationship?: string;
        type?: string;
        length?: number;
    };
    derivationType?: number;
    isBlockTransferred?: boolean;
}, service?: string): AnalyticsComponentEvent | AnalyticsCompositeEvent;
export {};
//# sourceMappingURL=analytics.d.ts.map