# @dcx/promise

Promise convenience class with some added functionality.

`AdobePromise` is not a scratch implementation, and depends on a globally available Promise constructor that adheres to the [A+ specification](https://promisesaplus.com/).

In practice, `AdobePromise` is a thennable object that allows a "props" object to be registered and forwarded to later promises in the chain, acting like both a Promise and whatever the type of "props" is defined to be. This is required to keep backwards compatibility with the objects previously returned by dcx-js, while adopting a Promise-based API. 

#### Capabilities
* Thennable
* Cancelable
* Forwards props object to later Promises
* Special handling for nested/explicitly-constructed Promises
* Can retrieve underlying Promise through `AdobePromise#getPromise`

### Generics
The AdobePromise class has 3 associated generics: `<T = any, E = any, X = unknown>`

#### T - Initial resolution type
The type of the `value` that the directly-constructed AdobePromise will have when fulfilled. Similar to the generic used in the standard Promise constructor: `new Promise<T>(){ ... }`.

> Note: This is only the initial AdobePromise callback resolution; `.then()` calls can return a new type, and `.then()` can be similarly typed with generics.

#### E - Error type
The type of the `reason` that the AdobePromise will have on a rejected state. Unlike the standard `Promise#catch` method, which has a reason of type `any`, `AdobePromise#catch`'s parameter will have a type of `E`.

#### X - Extension props
Properties object that is registered on the proxy. This object can change and grow as the AdobePromise is `.then()`'d, but special care is taken to make sure these props objects are not copied.

### Example

[`AdobeHTTPService#invoke`](https://dcx.ci.corp.adobe.com/job/dcx-js-stats/dcx-js_20Docs/interfaces/_dcx_common_types.adobehttpservice-2.html#invoke) returns the type: 

```ts
AdobePromise<AdobeResponse<T>, AdobeDCXError, RequestDescriptor>
```

This means that the returned object is a Promise that will either resolve to a value of type `AdobeResponse<T>`, or reject to a reason of type `AdobeDCXError`. Meanwhile, the returned object acts like a `RequestDescriptor` object, and references to it can be shared.
