/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeDCXError, AnyObject, IAdobePromise } from '@dcx/common-types';
export type PartialRecord<K extends keyof any, T> = {
    [P in K]?: T;
};
type onCancelFn<R = unknown> = (reason?: R) => void;
interface SettledRejectedPromise<E> {
    status: 'rejected';
    reason: E;
}
interface SettledFulfilledPromise<T> {
    status: 'fulfilled';
    value: T;
}
export type SettledPromise<T = any, E = any> = SettledRejectedPromise<E> | SettledFulfilledPromise<T>;
export declare const AdobePromise: {
    new <T = any, E = AdobeDCXError, X = unknown>(method: (resolve: (result?: T) => void, reject: (reason?: E) => void, onCancel: (handler: onCancelFn) => void) => unknown, source?: X): IAdobePromise<T, E, X>;
    reject: <E2 = any, X2 extends AnyObject = AnyObject>(reason?: E2 | PromiseLike<E2>, source?: X2) => IAdobePromise<any, E2, X2>;
    resolve: <T2 = any, E2 = any, X2 extends AnyObject = AnyObject>(val?: T2 | PromiseLike<T2> | undefined | Promise<T2>, source?: X2) => IAdobePromise<T2, E2, X2>;
    allSettled: <T2 = any, E2 = any, X2 extends AnyObject = AnyObject>(promises: (AdobePromise<T2, E2> | Promise<T2>)[], source?: X2) => IAdobePromise<SettledPromise<T2, E2>[], E2, X2>;
};
export type AdobePromise<T = any, E = any, X = unknown> = IAdobePromise<T, E, X>;
export {};
//# sourceMappingURL=AdobePromise.d.ts.map