/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { RepositoryLinksCache } from '@dcx/assets';
import { AdobeHTTPService } from '@dcx/common-types';
import { AdobeRepoAPISession } from './src/AdobeRepoAPISession';

export * from './src/AdobeRepoAPISession';
export * from './src/UploadResults';

/**
 * Constructs and returns a repository session instance.
 * @public
 * @example
 * ```js
 * // create instance of AdobeHTTPService
 * ...
 * var session = createRepoAPISession(service, 'https://platform-cs-stage-va7.adobe.io');
 * ```
 * @param   {AdobeHTTPService} httpService The HTTP service.
 * @param   {String}                  endpoint    The URL for the storage service.
 */
export const createRepoAPISession = (
    httpService: AdobeHTTPService,
    endpoint: string,
    linksCache?: RepositoryLinksCache,
): AdobeRepoAPISession => {
    return new AdobeRepoAPISession(httpService, endpoint, linksCache);
};
