/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeRepoUploadResult, AdobeUploadRecord, AdobeUploadResults } from '@dcx/common-types';
import { AdobeDCXError } from '@dcx/error';
import AdobePromise from '@dcx/promise';
import type { AdobeRepoAPISession } from '../AdobeRepoAPISession';
export { CURRENT_COMPONENT_DESCRIPTOR_HASH_TYPE, CURRENT_COMPONENT_DESCRIPTOR_VERSION } from './internal';
/**
 * Create UploadResults instance with empty records.
 *
 * @param compositeId       - The composite's UUID
 * @param compositeAssetId  - The composites cloud URN
 * @param repositoryId      - The repository ID
 */
export declare function createUploadResults(compositeId: string | undefined, compositeAssetId: string, repositoryId: string | undefined): AdobeUploadResults;
/**
 * Create upload record for use in UploadResults.
 *
 * @param componentId
 * @param etag
 * @param version
 * @param md5
 * @param length
 * @param type
 */
export declare function createUploadRecord(componentId: string, etag: string, version: string, md5: string, length: number, type: string): AdobeUploadRecord;
/**
 * Create UploadResults from serialized component descriptor string
 *
 * @param descriptor - Serialized component descriptor string
 *
 * Example component descriptor
 * {
    versionId: string,
    type: string,
    cloudAssetId: string,
    componentId: string,
    componentRevisionId: string,
    repositoryId: string,
    hashValue?: string,
    hashType?: string,
    etag?: string,
    size?: integer
}
 */
export declare function uploadResultsFromComponentDescriptor(descriptor: string): AdobeUploadResults;
/**
 * Create instance of UploadResults given an object
 * conforming to the AdobeRepoUploadResult interface.
 *
 * @param repoUploadResults object to convert
 */
export declare function uploadResultsFromAdobeRepoUploadResult(session: AdobeRepoAPISession, repoUploadResults: AdobeRepoUploadResult, compositeId?: string): AdobePromise<AdobeUploadResults, AdobeDCXError>;
//# sourceMappingURL=index.d.ts.map