/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeDCXError, AdobeResponse, AdobeResponseType, AdobeUploadRecord, AdobeUploadResults, DeserializedComponentDescriptor, InternalFunction, RepoDownloadStreamableReturn } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { AdobeRepoAPISession } from '../AdobeRepoAPISession';
/**
 * @internal - Used to indicate the serialization format for the serialized component descriptor.
 */
export declare const CURRENT_COMPONENT_DESCRIPTOR_VERSION = "0";
/**
 * @internal - Used to indicate the hash value format for the component descriptor.
 */
export declare const CURRENT_COMPONENT_DESCRIPTOR_HASH_TYPE = "md5";
/**
 * @internal
 */
export declare class UploadRecord implements AdobeUploadRecord {
    id: string;
    etag: string;
    version: string;
    md5: string;
    length: number;
    type: string;
    constructor(id: string, etag: string, version: string, md5: string, length: number, type: string);
}
/**
 * @internal
 */
export declare class UploadResults implements AdobeUploadResults {
    compositeId: string | undefined;
    compositeAssetId: string;
    repositoryId?: string | undefined;
    records: Record<string, AdobeUploadRecord>;
    /**
     * @internal
     */
    constructor(compositeId: string | undefined, compositeAssetId: string, repositoryId?: string | undefined);
    addUploadRecord(componentId: string, record: AdobeUploadRecord): void;
    getComponentDescriptor(componentId: string): string;
    getComponentURL(session: AdobeRepoAPISession, componentId: string): AdobePromise<{
        isPresignedUrl: boolean;
        url: string;
        response: AdobeResponse<'json'> | undefined;
    }, AdobeDCXError>;
    getComponent<T extends AdobeResponseType = 'defaultbuffer'>(session: AdobeRepoAPISession, componentId: string, responseType?: T): RepoDownloadStreamableReturn<T>;
    private _checkRAPIComponentParams;
}
/**
 * Get object representation of component descriptor.
 *
 * @param cloudAssetId
 * @param repositoryId
 * @param uploadRecord
 */
declare function _getComponentDescriptor(cloudAssetId: string, compositeId: string | undefined, repositoryId: string | undefined, uploadRecord: AdobeUploadRecord): DeserializedComponentDescriptor;
/**
 * Internals for testing
 *
 * @private
 * @internal
 */
export interface InternalTypes {
    _getComponentDescriptor: InternalFunction<typeof _getComponentDescriptor>;
}
/**
 * @private
 * @internal
 **/
export declare const internals: InternalTypes;
export {};
//# sourceMappingURL=internal.d.ts.map