import { getBaseConfigs } from '../../config/rollup.base.js';
import pkg from './package.json';

const confs = getBaseConfigs('dcxjs-util', pkg);

// include uuid in esm bundles
if (confs['browser:esm']) {
    const ext = confs['browser:esm'].external;
    confs['browser:esm'].external = (id) => id !== 'uuid' && ext(id);
}

if (confs['browser:esm2017']) {
    const ext = confs['browser:esm2017'].external;
    confs['browser:esm2017'].external = (id) => id !== 'uuid' && ext(id);
}

if (confs['node:esm']) {
    const ext = confs['node:esm'].external;
    confs['node:esm'].external = (id) => id !== 'uuid' && ext(id);
}

export default Object.values(confs);
