/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { getStartIdxOfMimeType, getSuffixIdxOfMimeType } from './AdobeDCXUtil';
import { arrayBufferToString } from './conversion';

const COMPOSITE_SNAPSHOT_TYPE_SUFFIX = '+dcxucf';

/**
 * verify a whether the input binary is a dcx snapshot by
 * checking the dcx snapshot mimetype and return the mimetype
 *
 * @param {ArrayBuffer | Buffer} buff
 * @return {string} mimetype
 */
export const verifyandGetSnapshotMimetype = (buff: ArrayBuffer | Buffer): string => {
    const mimtypeWithSuffix = arrayBufferToString(buff, 100);
    const idxOfSuffix = getSuffixIdxOfMimeType(mimtypeWithSuffix, COMPOSITE_SNAPSHOT_TYPE_SUFFIX);
    const startIdxOfMimeType = getStartIdxOfMimeType(mimtypeWithSuffix);
    if (idxOfSuffix > -1 && startIdxOfMimeType > -1) {
        return mimtypeWithSuffix.substring(startIdxOfMimeType, idxOfSuffix + COMPOSITE_SNAPSHOT_TYPE_SUFFIX.length);
    }
    return '';
};
