/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2023 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 *************************************************************************/

/**
 * Utilities related to retrying requests
 * @internal
 */

// import { newDebug } from '@dcx/logger';

// default to retry 429, 423 & 500 series codes, except 501 and 507
export const DEFAULT_RETRY_CODES = [/^(?!^501$|^507$)^(5\d{2})$|429|423$/];

const _isRegExp = (r: RegExp | number): r is RegExp => typeof r === 'object' && typeof r.test === 'function';
const _testStatus = (retryCode: RegExp | number, status: number) =>
    _isRegExp(retryCode) ? retryCode.test(status.toString()) : status === retryCode;

export function checkRetriable(
    status?: number,
    retryCodes: RegExp | number | (RegExp | number)[] = DEFAULT_RETRY_CODES,
): boolean {
    if (!status) {
        return false;
    }

    return Array.isArray(retryCodes)
        ? retryCodes.some((retryCode) => _testStatus(retryCode, status))
        : _testStatus(retryCodes, status);
}
