/* istanbul ignore file */
/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { isBrowser, isNode } from './AdobeDCXUtil';
import { isFunction, isObject } from './types';

let performance_: { now(): number } & Partial<Performance>;

/**
 * Get Performance (or Performance-like) module.
 * High precision if available, fall back to Date.
 * Only method guaranteed available is Performance#now().
 */
export const getPerformance = (): { now(): number } & Partial<Performance> => {
    if (performance_) {
        return performance_;
    }

    const isNode_ = isNode();
    if (isNode_ && isObject(global.performance) && isFunction(global.performance.now)) {
        performance_ = global.performance;
    } else if (
        isNode_ &&
        isObject((global as any).perf_hooks) &&
        isObject((global as any).perf_hooks.performance) &&
        isFunction((global as any).perf_hooks.performance.now)
    ) {
        performance_ = (global as any).perf_hooks.performance;
    } else if (isBrowser() && isObject(self.performance) && isFunction(self.performance.now)) {
        performance_ = self.performance;
    } else {
        performance_ = Date;
    }

    return performance_;
};

/**
 * Get now as milliseconds.
 */
export const now = (): number => {
    const performance = getPerformance();
    return performance.now();
};
