/**
 * perform an async operation with some maximum number of retries.
 * @param fn An async function to retry on rejection
 * @param maxRetries - The maximum number of times to retry the operation, default 3.
 * @returns return type of provided fn.
 */
export function withRetries<T extends Promise<any>>(fn: () => T, maxRetries = 3) {
    return fn().catch((error) => {
        if (maxRetries) {
            return withRetries(fn, maxRetries - 1);
        }
        throw error;
    });
}
