/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/**
 * Detect Node.js Environment
 * ref: https://github.com/iliakan/detect-node/
 *
 * @return {boolean}
 */
export declare const isNode: () => boolean;
/**
 * Detect Browser Environment
 *
 * @return {boolean}
 */
export declare const isBrowser: () => boolean;
export declare const isWebWorker: () => boolean;
/**
 * Detect if SDK is built for browser
 *
 * @return {boolean}
 */
export declare const isBrowserSDK: () => boolean;
export declare const SDKType: () => string;
/**
 * Generate UUID
 *
 * @return {string} UUIDv4
 */
export declare const generateUuid: () => string;
/**
 *  verify whether the input string is a valid rfc4122 uuid
 * @param {string} inputStr need to be verify whether it follow rfc4122 uuid
 * @returns {boolean}
 */
export declare const verifyUuid: (inputStr: string) => boolean;
/**
 * Merges the objects in the argument list, modifying and returning the first.
 * To merge into a new object, pass {} as the first parameter.
 * Only arguments (except the first) that are dictionaries are merged, so passing
 * 'undefined' as a parameter has no effect.
 * @param   {Object} res The object to merge.
 * @returns {Object} The merged object.
 */
export declare const merge: (...objs: unknown[]) => any;
/**
 * Merge objects recursively from right to left
 * @param {object} target
 * @param {object} sources
 * @returns {*}
 */
export declare const mergeDeep: (target: any, ...sources: any[]) => any;
/**
 * Appends path elements, adding a slash between non-null components if they do not already start or end in a slash.
 * NOTE: appending a '/' will ensure the path ends in a slash.
 * @private
 * @returns {the} appended path.
 */
export declare const appendPathElements: (...objs: (string | undefined)[]) => string;
/**
 * Returns true if the given path is a valid path for a component or node.
 *
 * A path is valid if all of its components (derived by splitting it with the forward
 * slash / as a separator) fulfill these criteria:
 * - it must be 1 to 255 characters long
 * - it must not end with a . (dot)
 * - it must not contain any of the following characters
 * o U+0022 " QUOTATION MARK
 * o U+002A * ASTERISK
 * o U+007F | vertical bar
 * o U+003A : COLON
 * o U+003C < LESS-THAN SIGN
 * o U+003E > GREATER-THAN SIGN
 * o U+003F ? QUESTION MARK
 * o U+005C \ REVERSE SOLIDUS
 * o The C0 controls, U+0000 through U+001F and U+007F
 * o it does not end with a . (period) or ' ' (space)
 * - it does not equal:
 * o manifest
 * o mimetype
 * o .dcx*
 * o dcx*
 * - it does not equal to any of the following names with or without a file extension:
 * o CON
 * o PRN
 * o AUX
 * o NUL
 * o COM[1-9]
 * o LPT[1-9]
 * @see [schema definition](https://git.corp.adobe.com/caf/xcm/blob/master/schemas/dcx/manifest.schema.json#L295)
 * @param   {String}  path
 * @returns {Boolean}
 */
export declare const isValidPath: (path: string, pathIsAbsolute?: boolean) => boolean;
export declare const isValidAbsolutePath: (absPath: string) => boolean;
/**
 * Does nothing, returns nothing
 * @private
 */
export declare const noOp: () => void;
/**
 * Consume and discard the data from a stream.
 * @private
 * @param {Object}   stream   the stream to drain.
 * @param {Function} callback if not undefined, called when stream is consumed
 * @param {Function} data     if not undefined, called with received data
 */
export declare const consumeStream: (stream: any, callback?: any, data?: any) => void;
/**
 * Creates and returns a flat copy of the object passed in. This means that the returned object
 * has the same keys and for each key exactly the same value as the original. This can be used
 * to create copies of lookup tables.
 * @private
 * @param   {Object} obj
 * @returns {Object}
 */
export declare const flatCopy: <T extends Record<string, unknown> = any>(obj: T) => T;
/**
 * Creates and returns a deep copy of the object utilizing JSON.
 * @private
 * @param   {Object}   obj
 * @returns {Object}
 */
export declare const deepCopy: <T extends object>(obj: T) => T;
/**
 * Does a deep compare of two objects.
 * @private
 * @param   {Object}  obj1               One object.
 * @param   {Object}  obj2               The other object.
 * @param   {Object}  propertiesToIgnore Optional. Object with properties that should not be compared.
 * @returns {Boolean}
 */
export declare const objectsEqual: (obj1: Object, obj2: Object, propertiesToIgnore?: Record<string, boolean>) => boolean;
/**
 * Extract the path (query and fragment) from a URL.
 * Should potentially be moved to dcx-js and made internal
 * @public
 * @param   {String} url the url
 * @returns {Object}    { scheme, authority, path, query, fragment }
 */
export declare const parseURI: (url: string) => {
    scheme: string;
    authority: string;
    path: string;
    query: string;
    fragment: string;
};
export declare const endPointOf: (href: string) => string | undefined;
/**
 * Get domain from URL, does not include subdomains.
 *
 * URL may or may not contain port number, protocol, path or query parameters
 *
 * @param url
 */
export declare const getDomainFromURL: (url: string) => string;
/**
 * Ensure that the href begins with a slash if it is a relative href
 * @private
 * @param   {String} href the href
 * @returns {String}    the href
 */
export declare const ensureRelativeHrefStartsWithSlash: (href: string) => string;
export declare const isHexChar: (ch: string) => boolean;
export declare const isPctEncoding: (str: string) => boolean;
export declare const hexVal: (ch: string) => number;
/**
 * Returns a time stamp in the form of the number of milliseconds since 1 January 1970 00:00:00 UTC.
 * @param   {Boolean} roundDownToFullSeconds Whether to limit the resolutio to full seconds. Can be
 *                                         useful if you want to use the timestamp to compare it
 *                                         with the modification time stamps of files, which are
 *                                         also limited to full seconds.
 * @returns {Number}  The number of milliseconds since 1 January 1970 00:00:00 UTC.
 */
export declare const timeStamp: (roundDownToFullSeconds?: boolean) => number;
/** @internal */
export declare const _toUTF8Array: (str: string) => number[];
/**
 * Escapes path characters and normalizes unicode
 *
 * @param {string} path - path to escape
 */
export declare const escapeURLPath: (path: string) => string;
/**
 * Take out leading slash for an absolute path
 *
 * @param {string} path - path to be processed
 */
export declare const removeLeadingSlashForPath: (path: string) => string;
/**
 * Returns an expansion of URI template using the supplied values
 * @param {String} template URI template string
 * @param {Object} values   Map from name to values. Values are either strings or arrays or objects.
 *                          A string is a simple value; an array is treated as a sequence of values interpreted
 *                          as strings and an an object is treated as a set of (string, string) pairs.
 * @returns {String} The expanded URI string
 */
export declare const expandURITemplate: (template: string, values?: Record<string, (string | number) | (string | number)[] | Record<string, string | number>>) => string;
export declare const getSuffixIdxOfMimeType: (type: string, suffix: string) => number;
export declare const getStartIdxOfMimeType: (type: string) => number;
/**
 * Returns the first matching group from input string
 * @param {String} responseData response body
 * @param {string | RegExp} regexp   Regex pattern
 * @returns {String} pick the first matched group otherwise return empty string
 */
export declare const getFirstRegexpCapture: (responseData: string, regexp: string | RegExp) => string;
//# sourceMappingURL=AdobeDCXUtil.d.ts.map