/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2023 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { BasicLink, RenditionLink, RenditionOptions, RequireAtLeastOne } from '@dcx/common-types';
type RenditionLinkSelector = (links: RenditionLink[], options?: RenditionOptions) => RenditionLink;
type BasicLinkSelector<T> = (link: BasicLink[], options?: T) => BasicLink;
type LinkExpander<T> = (link: string, values?: T) => string;
export interface LinkProvider<T extends Record<string, any>> {
    selector?: T extends RequireAtLeastOne<Exclude<RenditionOptions, keyof BasicLink>, keyof RenditionOptions> ? RenditionLinkSelector : BasicLinkSelector<T>;
    expander?: LinkExpander<T>;
}
export declare function provideLink<T extends Record<string, any>>(links: BasicLink | BasicLink[], linkProvider?: LinkProvider<T>, opts?: T): any;
export declare function provideLink(links: RenditionLink | RenditionLink[], linkProvider?: LinkProvider<RenditionOptions>, opts?: RenditionOptions): any;
export {};
//# sourceMappingURL=LinkProvider.d.ts.map