/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
interface _Watchable<T> {
    watchProperty(prop: keyof T, handler: (next: T[typeof prop], current?: T[typeof prop], target?: T) => void): void;
    revokeWatchProxy(): T;
}
export type Watchable<T> = _Watchable<T> & T;
/**
 * Create watch proxy around object.
 * Adds `watchProperty` method to the object.
 * Allows watching changes on properties.
 * Handlers are called just before applying the change to the object.
 *
 * @param {unknown} obj - Object to wrap in proxy
 */
export declare function WatchProxy<T extends object = {}>(obj: T): T & Watchable<T>;
export {};
//# sourceMappingURL=WatchProxy.d.ts.map