/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/// <reference types="node" />
/**
 * Utility functions for converting between different data types
 */
export declare function arrayBufferToString(buff: ArrayBuffer | Buffer, numOfBytes?: number): string;
export declare function stringToBuffer(data: string): Buffer | Uint8Array;
export declare function dataToBuffer(data: Buffer | Blob | ArrayBuffer | string): undefined | Buffer | Blob | ArrayBuffer;
export declare function concatUint8Arrays(array1: Uint8Array, array2: Uint8Array): Uint8Array;
export declare function objectFromEntries<T = any>(entries: IterableIterator<[string, T]> | ReturnType<typeof Object.entries>): Record<string, T>;
/**
 * Converts an array of items into an array of subarrays. Each subarray should have a maximum length of chunkSize
 * Ordering of subarrays is not guaranteed to match the ordering of the original array.
 * ex: `chunk([1,2,3,4,5], 2) // [[5],[3,4],[1,2]]`
 * @param array
 * @param chunkSize
 * @returns
 */
export declare function chunkArray<T extends any[]>(array: T, chunkSize: number): any;
/**
 * Converts a ReadableStream to an Async Iterable using a Generator
 * This functionality will hopefulyl be built directly into the WHATWG ReadableStreams in the future
 * Some tracking information can be found in the referenced link.
 * @see {@link https://github.com/whatwg/streams/issues/778#issuecomment-461341033 | WHATWG Stream Async Iterator Issue}
 * @param stream the stream to read from
 */
export declare function asyncIterableFromStream(stream: any): AsyncGenerator<any, void, unknown>;
//# sourceMappingURL=conversion.d.ts.map