/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/**
 * Parses the http headers in allHeadersAsText as per http://www.w3.org/Protocols/rfc2616/rfc2616-sec4.html and returns
 * a dictionary with the lower-cased header fields as keys and the header values as values.
 * @private
 * @param   {String} allHeadersAsText
 * @returns {Object}
 */
export declare const parseHeaders: (allHeadersAsText: string) => Record<string, string>;
/**
 * Turns header keys to lowercase and removes undefined value entries.
 *
 * @param headers - incoming headers to be normalized
 */
export declare const normalizeHeaders: (headers: Record<string, string | string[]>) => Record<string, string>;
//# sourceMappingURL=headers.d.ts.map