/**
 * ref: https://github.com/jhermsmeier/node-http-link-header/blob/master/LICENSE.md
 */
import { AdobeAssetWithLinks, LinkMode, LinkSet } from '@dcx/common-types';
export declare class Link {
    /** @type {Array} URI references */
    refs: Record<string, any>[];
    /**
     * Link
     * @constructor
     * @param {String} [value]
     * @returns {Link}
     */
    constructor(value?: string);
    /**
     * Get refs with given relation type
     * @param {String} value
     * @returns {Array<Object>}
     */
    rel(value: any): Record<string, unknown>[];
    /**
     * Get refs where given attribute has a given value
     * @param {String} attr
     * @param {String} value
     * @returns {Array<Object>}
     */
    get(attr: string, value: string): Record<string, any>[];
    set(link: Record<string, any>): Link;
    has(attr: string, value: string): boolean;
    parse(pValue: string, pOffset?: number): this;
    toString(): string;
}
/**
 * Generic link parser to get a specific property value from a link relationship
 * @param links             A LinkSet provided in any of the formats in which they may be stored on a dcx-js class
 * @param relationship      The relationship key
 * @param property          The property to pull from the relationship
 * @param linkMode          If the relationship contains an array of links, allows specifying the exact mode to return the property for.
 * @return                  The property if the relationship and property exist on the provided links. Else undefined
 */
export declare function getLinkProperty(links: AnyLinkSetInput, relationship: string, property: string, linkMode?: LinkMode): string | undefined;
/**
 * Generic link parser to get the href property of a link relationship
 * @param links             A LinkSet provided in any of the formats in which they may be stored on a dcx-js class
 * @param relationship      The relationship key
 * @param linkMode          If the relationship contains an array of links, allows specifying the exact mode to return the property for.
 * @return                  The href if the relationship and href exists on the provided links. Else undefined
 */
export declare function getLinkHref(links: AnyLinkSetInput, relationship: string, linkMode?: LinkMode): string;
/**
 * Generic link parser to get the result href from a templated link with values.
 *
 * @param links             A LinkSet provided in any of the formats in which they may be stored on a dcx-js class
 * @param relationship      The relationship key
 * @param values            The key/values to bind to the template. If any value is undefined, it is stripped from the values object.
 * @param linkMode          If the relationship contains an array of links, allows specifying the exact mode to return the property for.
 * @return                  The expanded href template if the relationship exists and the link is marked as templated=true. Else undefined
 */
export declare function getLinkHrefTemplated(links: AnyLinkSetInput, relationship: string, values: Record<string, (string | number | undefined) | (string | number)[] | Record<string, string | number | undefined>>, linkMode?: LinkMode): string;
export declare const parse: (value: string, offset?: number) => Link;
type UnderscoreLinksObject = {
    _links: LinkSet;
};
type LinksObject = {
    links: LinkSet;
};
type AnyLinkSetInput = LinkSet | UnderscoreLinksObject | LinksObject | AdobeAssetWithLinks | undefined;
export {};
//# sourceMappingURL=link.d.ts.map