/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/**
 * Object (POJO) utilities
 */
export declare function safeGet<T extends object, K extends keyof T>(obj: T, key: K): T[K] | undefined;
/**
 * Combines objects, mutating them in place to proxy to each object.
 * Assigns to the left, so later objects in the argument list may overwrite existing properties.
 * Does not combine deeply, properties that are objects themselves will not be combined.
 *
 * TODO: Also assign getters/setters in the case of class instances.
 *
 * @param {unknown} sources - objects to combine
 */
export declare function combineInPlace(...sources: unknown[]): void;
/**
 * Prune undefined entries from an object.
 * Returns new object, does not mutate existing object.
 * Does not recurse, only prunes first level.
 *
 * @param {Object} obj - object to prune
 */
export declare function pruneUndefined<T = Record<string, unknown>>(obj: unknown): T;
//# sourceMappingURL=object.d.ts.map