/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/// <reference types="node" />
/// <reference types="node" />
import { PlatformReadableStream } from '@dcx/common-types';
import type { Readable } from 'stream';
export declare const isDefined: <T extends unknown>(o: T | null | undefined) => o is T;
export declare const isUndefined: <T extends unknown>(o: T | null | undefined) => o is null | undefined;
/**
 * Determine if a value is a Stream
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Stream, otherwise false
 */
export declare const isReadableStream: (val: unknown) => val is PlatformReadableStream;
export declare const isNodeReadableStream: (val: unknown) => val is Readable;
export declare const isWHATWGReadableStream: (val: unknown) => val is ReadableStream<any>;
export declare const isObject: (val: unknown) => val is Record<string, unknown>;
/**
 * @deprecated in v7 - removed in v8 (use isAnyFunction instead)
 */
export declare const isFunction: <OUT = unknown, IN = unknown>(val: unknown) => val is Function | AsyncFunction<OUT, IN>;
type AsyncFunction<OUT = unknown, IN = unknown> = Function & ((...args: IN[]) => Promise<OUT>);
/**
 * This will narrow down to any function which returns a promise.
 * It can additionally accept parameter types to allow for more specific
 * narrowing of the value under test.
 *
 * i.e.
 * ```typescript
 * if (isAsyncFunction<number>(maybeFn)) {
 *   const valPlus5 = 5 + (await maybeFn());
 * }
 *```

 * Note that the actual return value is not directly tested.
 * The generics cannot be used for further discrimination/matching.
 * As an example, the following code will ALWAYS result in the first branch being taken.
 *
 * ```typescript
 * const booleanAsyncFn = async () => false;
 *
 * if (isAsyncFunction<number>(booleanAsyncFn)) {
 *   // This branch will be executed as return types are not evaluated against generic type parameters.
 * } else if (isAsyncFunction<boolean>(booleanAsyncFn)) {
 *   // does not get executed -- return values are not inspected
 * }
 * ```
 *
 * @deprecated in v7 - removed in v8 (use isAnyFunction instead)
 */
export declare const isAsyncFunction: <OUT = unknown, IN = unknown>(val: unknown) => val is AsyncFunction<OUT, IN>;
export declare const isAnyFunction: <OUT = unknown, IN = unknown>(val: unknown) => val is Function | AsyncFunction<OUT, IN>;
export declare const isPromise: (p: unknown) => p is Promise<unknown>;
export declare const isArray: <T = unknown>(p: unknown) => p is T[];
export declare const isVoid: (p: unknown) => p is void;
export declare const isBuffer: (p: unknown) => p is Buffer;
export declare const isArrayBuffer: (p: unknown) => p is unknown[];
export declare const isArrayBufferView: (p: unknown) => p is unknown[];
/**
 * Returns true if string matches:
 * `application/json`
 * `application/<anything>+json`
 * `<anything>;application/json;<anything>`
 * `<anything>;application/<anything>+json;<anything>`
 *
 * @param str
 */
export declare const isJsonContentType: (str: string) => boolean;
/**
 * Check if string matches a Shared Cloud asset's URN
 *
 * Matches a string with the format:
 * `urn:aaid:{two chars of a-Z}:{to chars of a-Z}:{valid URNv1-5}`
 * ie. `urn:aaid:sc:US:48a91bdd-d956-5ac1-b45e-c1ab1b6bd9f7`
 * OR `urn:aaid:xy:EU:48a91bdd-d956-5ac1-b45e-c1ab1b6bd9f7`
 *
 * An alternate form, matching only the prefix urn:aaid:sc:{2 char region}:
 * `/^urn:aaid:sc:[a-zA-Z]{2}:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i`
 *
 * @param {string} str
 * @deprecated in v7 - removed in v8
 */
export declare const isValidAdobeURN: (str: string) => boolean;
export {};
//# sourceMappingURL=types.d.ts.map