import { JSONPatchDocument } from '@dcx/common-types';

export declare interface AdobeXMPUtilContext {
    patchDocument: JSONPatchDocument;
}

export declare function appendHistoryEvent(this: AdobeXMPUtilContext | void | unknown, action: string, creatorTool?: string, when?: string, instanceId?: string): JSONPatchDocument;

export declare function deleteProperty(this: AdobeXMPUtilContext | void | unknown, namespace: string, name: string): JSONPatchDocument;

export declare function initializeXMPJSON(creatorTool?: string, docId?: string, when?: string): {
    'xmp:ModifyDate': string;
    'xmp:MetadataDate': string;
    'xmp:CreatorTool': string;
    '@context': {
        xmpMM: string;
        stEvt: string;
        xmp: string;
    };
    'xmpMM:DocumentID': string;
    'xmpMM:History': {
        '@list': {
            'stEvt:softwareAgent': string;
            'stEvt:action': string;
            'stEvt:when': string;
            'stEvt:instanceID': string;
        }[];
    };
    'xmp:CreateDate': string;
    '@id': string;
    'xmpMM:InstanceID': string;
    'xmpMM:OriginalDocumentID': string;
};

export declare function initializeXMPXML(creatorTool?: string, docId?: string, when?: string, historyEvents?: string[], derivedWithData?: string): string;

export declare function makeDerivedWithAction(this: AdobeXMPUtilContext | void | unknown, creatorTool: string | undefined, action: string, newDocId?: string, when?: string): JSONPatchDocument;

export declare function makeDerivedWithXML(originalDocId?: string, docId?: string, instanceId?: string, lastModifyDate?: string): string;

export declare function makeHistoryEventXML(creatorTool: string | undefined, action: string, newDocId?: string, when?: string): string;

export declare function parseXML(str: string): XMLParser;

export declare function registerNamespace(this: AdobeXMPUtilContext | void, ns: string, shortName: string): JSONPatchDocument;

/**
 * Incoming XML may or may not include all fields
 * in the stub defined in core. If not, add missing fields.
 * Generates document/instance IDs if they don't exist.
 *
 * @note
 * This repair is not extensive. If a field exists with an invalid value,
 * it will not be repaired. Likewise for certain expected history events.
 */
export declare function repairXMPXML(xmp: string, creatorTool?: string, docId?: string, when?: string): string;

export declare function setCreatorTool(this: AdobeXMPUtilContext | void | unknown, creatorTool: string): JSONPatchDocument;

export declare function setProperty(this: AdobeXMPUtilContext | void | unknown, namespace: string, name: string, value: unknown): JSONPatchDocument;

export declare function updateLastHistoryEvent(this: AdobeXMPUtilContext | void | unknown, action?: string, creatorTool?: string, when?: string): JSONPatchDocument;

export declare class XMLElement extends XMLNodeBase {
    protected _data: XNode;
    constructor(data: XNode);
    setAttribute(name: string, value: string): void;
    getAttribute(name: string): unknown | undefined;
    appendChild(tagName: string, attributes?: Record<string, string>, children?: (XNode | string)[]): XMLElement;
}

declare class XMLNodeBase {
    protected _data: Partial<XNode> & Pick<XNode, 'children'>;
    constructor(data: XNode);
    getElementsByTagName(tagName: string): XMLElement[];
}

export declare class XMLParser extends XMLNodeBase {
    constructor(data?: XNode);
    parse(str: string): XMLParser;
    getElementsByTagName(tagName: string): XMLElement[];
    toString(): string;
}

export declare interface XNode {
    tagName: string;
    attributes: Record<string, string>;
    children: (string | XNode)[];
    pos?: number;
}

export { }
