/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { JSONPatchDocument } from '@dcx/common-types';
import { isArray, isObject } from '@dcx/util';

export interface AdobeXMPUtilContext {
    patchDocument: JSONPatchDocument;
}

export function _getPatchDocumentFromContext(ctx: AdobeXMPUtilContext | void | unknown): JSONPatchDocument {
    return isObject(ctx) && isArray(ctx.patchDocument) ? (ctx.patchDocument as JSONPatchDocument) : [];
}
