import { generateUuid } from '@dcx/util';
import { DEFAULT_CREATOR_TOOL } from './private';

export function makeDerivedWithXML(
    originalDocId?: string,
    docId?: string,
    instanceId?: string,
    lastModifyDate: string = new Date().toISOString(),
): string {
    if (!originalDocId && !docId && !instanceId) {
        originalDocId = generateUuid();
    }
    /* istanbul ignore next */
    return `<xmpMM:DerivedFrom
        stRef:documentID="xmp.did:${docId || instanceId || originalDocId}"
        stRef:instanceID="xmp.iid:${instanceId || docId || originalDocId}"
        stRef:originalDocumentID="xmp.did:${originalDocId || docId || instanceId}"
        stRef:lastModifyDate="${lastModifyDate}"/>`;
}

export function makeHistoryEventXML(
    creatorTool: string = DEFAULT_CREATOR_TOOL,
    action: string,
    newDocId: string = generateUuid(),
    when: string = new Date().toISOString(),
): string {
    return `<rdf:li
    stEvt:action="${action}"
    stEvt:instanceID="xmp.iid:${newDocId}"
    stEvt:when="${when}"
    stEvt:softwareAgent="${creatorTool}"/>`;
}
